/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.ui;

import com.wynntils.core.components.Handlers;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.PauseMenuInitEvent;
import com.wynntils.screens.base.WynntilsMenuScreenBase;
import com.wynntils.screens.maps.GuildMapScreen;
import com.wynntils.screens.wynntilsmenu.WynntilsMenuScreen;
import com.wynntils.utils.mc.McUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.UI)
public class WynncraftPauseScreenFeature
extends Feature {
    private static final String ADVANCEMENTS = "gui.advancements";
    private static final String STATS = "gui.stats";
    private static final String SEND_FEEDBACK = "menu.sendFeedback";
    private static final String REPORT_BUGS = "menu.reportBugs";

    @SubscribeEvent
    public void onPauseScreenInitEvent(PauseMenuInitEvent event) {
        PauseScreen pauseScreen = event.getPauseScreen();
        ArrayList<Renderable> renderables = new ArrayList<Renderable>(pauseScreen.renderables);
        this.replaceButtonFunction(renderables, ADVANCEMENTS, (Component)Component.translatable((String)"feature.wynntils.wynncraftPauseScreen.territoryMap.name").withStyle(ChatFormatting.DARK_AQUA), button -> McUtils.setScreen(GuildMapScreen.create()));
        this.replaceButtonFunction(renderables, STATS, (Component)Component.translatable((String)"feature.wynntils.wynncraftPauseScreen.wynntilsMenuButton.name"), button -> WynntilsMenuScreenBase.openBook(WynntilsMenuScreen.create()));
        this.replaceButtonFunction(renderables, SEND_FEEDBACK, (Component)Component.translatable((String)"feature.wynntils.wynncraftPauseScreen.classSelectionButton.name"), button -> {
            McUtils.setScreen(null);
            McUtils.mc().mouseHandler.grabMouse();
            Handlers.Command.sendCommandImmediately("class");
        });
        this.replaceButtonFunction(renderables, REPORT_BUGS, (Component)Component.translatable((String)"feature.wynntils.wynncraftPauseScreen.hubButton.name"), button -> {
            McUtils.setScreen(null);
            McUtils.mc().mouseHandler.grabMouse();
            Handlers.Command.sendCommandImmediately("hub");
        });
        event.getPauseScreen().clearWidgets();
        for (Renderable renderable : renderables) {
            if (!(renderable instanceof AbstractWidget)) continue;
            AbstractWidget widget = (AbstractWidget)renderable;
            event.getPauseScreen().addRenderableWidget((GuiEventListener)widget);
        }
    }

    private void replaceButtonFunction(List<Renderable> widgets, String translationKey, Component component, Button.OnPress onPress) {
        Button oldButton = widgets.stream().filter(Button.class::isInstance).map(Button.class::cast).filter(button -> this.isButton((Button)button, translationKey)).findFirst().orElse(null);
        if (oldButton == null) {
            return;
        }
        Button newButton = new Button.Builder(component, onPress).pos(oldButton.getX(), oldButton.getY()).size(oldButton.getWidth(), oldButton.getHeight()).build();
        widgets.set(widgets.indexOf(oldButton), (Renderable)newButton);
    }

    private boolean isButton(Button button, String translationKey) {
        TranslatableContents translatableContents;
        ComponentContents componentContents;
        return button.visible && (componentContents = button.getMessage().getContents()) instanceof TranslatableContents && (translatableContents = (TranslatableContents)componentContents).getKey().equals(translationKey);
    }
}

