/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.utilities;

import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.StartDisabled;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.models.worlds.event.CutsceneStartedEvent;
import com.wynntils.utils.mc.McUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.neoforged.bus.api.SubscribeEvent;

@StartDisabled
@ConfigCategory(value=Category.UTILITIES)
public class AutoSkipCutscenesFeature
extends Feature {
    @Persisted
    private final Config<SkipCondition> skipCondition = new Config<SkipCondition>(SkipCondition.ALL);

    @SubscribeEvent
    public void onCutsceneStarted(CutsceneStartedEvent e) {
        boolean shouldSkip = false;
        if (e.isGroupCutscene() && this.skipCondition.get() != SkipCondition.SOLO) {
            shouldSkip = true;
        } else if (!e.isGroupCutscene() && this.skipCondition.get() != SkipCondition.GROUP) {
            shouldSkip = true;
        }
        e.setCanceled(shouldSkip);
        if (shouldSkip) {
            McUtils.mc().getConnection().send((Packet)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.SWAP_ITEM_WITH_OFFHAND, BlockPos.ZERO, Direction.DOWN));
        }
    }

    private static enum SkipCondition {
        ALL,
        SOLO,
        GROUP;

    }
}

