/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.wynntils;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.services.athena.type.UpdateResult;
import com.wynntils.utils.mc.McUtils;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.WYNNTILS)
public class UpdatesFeature
extends Feature {
    @Persisted
    private final Config<Boolean> updateReminder = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> autoUpdate = new Config<Boolean>(false);

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent event) {
        if (!event.isFirstJoinWorld()) {
            return;
        }
        if (!Services.Update.shouldPromptUpdate()) {
            return;
        }
        CompletableFuture.runAsync(() -> Services.Update.getLatestBuild().whenCompleteAsync((updateInfo, throwable) -> Managers.TickScheduler.scheduleNextTick(() -> {
            if (updateInfo == null) {
                WynntilsMod.info("Couldn't fetch latest version, not attempting update reminder or auto-update.");
                return;
            }
            Services.Update.setHasPromptedUpdate(true);
            if (((Boolean)this.updateReminder.get()).booleanValue()) {
                if (WynntilsMod.isDevelopmentEnvironment()) {
                    WynntilsMod.info("Tried to show update reminder, but we are in development environment.");
                    return;
                }
                UpdatesFeature.remindToUpdateIfExists(updateInfo.version());
            }
            if (((Boolean)this.autoUpdate.get()).booleanValue()) {
                if (WynntilsMod.isDevelopmentEnvironment()) {
                    WynntilsMod.info("Tried to auto-update, but we are in development environment.");
                    return;
                }
                WynntilsMod.info("Attempting to auto-update.");
                McUtils.sendMessageToClient((Component)Component.translatable((String)"feature.wynntils.updates.updating").withStyle(ChatFormatting.YELLOW));
                CompletableFuture<UpdateResult> completableFuture = Services.Update.tryUpdate();
                completableFuture.whenCompleteAsync((result, t) -> McUtils.sendMessageToClient((Component)result.getMessage()));
            }
        })));
    }

    private static void remindToUpdateIfExists(String newVersion) {
        MutableComponent clickable = Component.translatable((String)"feature.wynntils.updates.reminder.clickable");
        clickable.setStyle(clickable.getStyle().withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/wynntils update")).withUnderlined(Boolean.valueOf(true)).withBold(Boolean.valueOf(true)));
        McUtils.sendMessageToClient((Component)Component.literal((String)"[Wynntils]: ").withStyle(ChatFormatting.GREEN).append((Component)Component.translatable((String)"feature.wynntils.updates.reminder", (Object[])new Object[]{WynntilsMod.getVersion(), newVersion}).append((Component)clickable).withStyle(ChatFormatting.GREEN)));
    }
}

