/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.actionbar;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handler;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.actionbar.ActionBarSegment;
import com.wynntils.handlers.actionbar.ActionBarSegmentMatcher;
import com.wynntils.handlers.actionbar.event.ActionBarRenderEvent;
import com.wynntils.handlers.actionbar.event.ActionBarUpdatedEvent;
import com.wynntils.mc.event.SystemMessageEvent;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.utils.type.IterationDecision;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;

public final class ActionBarHandler
extends Handler {
    private static final ResourceLocation COORDINATES_FONT = ResourceLocation.withDefaultNamespace((String)"hud/gameplay/default/top_right");
    private static final FallBackSegmentMatcher FALLBACK_SEGMENT_MATCHER = new FallBackSegmentMatcher();
    private static final Pattern PERCENT_PATTERN = Pattern.compile("%");
    private final List<ActionBarSegmentMatcher> segmentMatchers = new ArrayList<ActionBarSegmentMatcher>();
    private StyledText lastParsedActionBarText = StyledText.EMPTY;
    private List<ActionBarSegment> lastMatchedSegments = new ArrayList<ActionBarSegment>();

    public void registerSegment(ActionBarSegmentMatcher segmentMatcher) {
        this.segmentMatchers.add(segmentMatcher);
    }

    @SubscribeEvent
    public void onActionBarUpdate(SystemMessageEvent.GameInfoReceivedEvent event) {
        StyledText packetText = StyledText.fromComponent(event.getMessage());
        StyledText actionBarText = packetText.iterate((part, changes) -> {
            if (part.getPartStyle().getFont().equals((Object)COORDINATES_FONT)) {
                changes.remove(part);
                return IterationDecision.BREAK;
            }
            return IterationDecision.CONTINUE;
        });
        if (actionBarText.isEmpty()) {
            WynntilsMod.warn("Failed to find action bar text in packet: " + packetText.getString());
            return;
        }
        List<ActionBarSegment> matchedSegments = this.matchSegments(actionBarText, packetText);
        ActionBarRenderEvent actionBarRenderEvent = new ActionBarRenderEvent(matchedSegments);
        WynntilsMod.postEvent(actionBarRenderEvent);
        for (ActionBarSegment disabledSegment : actionBarRenderEvent.getDisabledSegments()) {
            actionBarText = actionBarText.replaceFirst(disabledSegment.getSegmentText(), "");
        }
        StyledText renderedText = actionBarText;
        if (actionBarRenderEvent.shouldRenderCoordinates()) {
            StyledText coordinatesText = packetText.iterate((part, changes) -> {
                if (!COORDINATES_FONT.equals((Object)part.getPartStyle().getFont())) {
                    changes.remove(part);
                }
                return IterationDecision.CONTINUE;
            });
            renderedText = renderedText.append(coordinatesText);
        }
        if (packetText.equals(renderedText)) {
            return;
        }
        event.setMessage((Component)renderedText.getComponent());
    }

    private List<ActionBarSegment> matchSegments(StyledText actionBarText, StyledText packetText) {
        List<ActionBarSegment> matchedSegments;
        if (this.lastParsedActionBarText.equals(packetText)) {
            matchedSegments = this.lastMatchedSegments;
        } else {
            matchedSegments = this.parseActionBarSegments(actionBarText);
            this.lastParsedActionBarText = packetText;
            this.lastMatchedSegments = matchedSegments;
            if (WynntilsMod.isDevelopmentBuild() || WynntilsMod.isDevelopmentEnvironment()) {
                ActionBarHandler.debugChecks(matchedSegments, actionBarText);
            }
            WynntilsMod.postEvent(new ActionBarUpdatedEvent(matchedSegments));
        }
        return matchedSegments;
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent event) {
        this.lastParsedActionBarText = StyledText.EMPTY;
        this.lastMatchedSegments = new ArrayList<ActionBarSegment>();
    }

    private List<ActionBarSegment> parseActionBarSegments(StyledText actionBarText) {
        ArrayList<ActionBarSegment> matchedSegments = new ArrayList<ActionBarSegment>();
        for (ActionBarSegmentMatcher segmentMatcher : this.segmentMatchers) {
            ActionBarSegment parsedSegment = segmentMatcher.parse(PERCENT_PATTERN.matcher(actionBarText.getString()).replaceAll(""));
            if (parsedSegment == null) continue;
            matchedSegments.add(parsedSegment);
            actionBarText = actionBarText.replaceFirst(parsedSegment.getSegmentText(), "%");
        }
        Arrays.stream(actionBarText.split("%")).filter(text -> !text.isEmpty()).forEach(part -> matchedSegments.add(FALLBACK_SEGMENT_MATCHER.parse(part.getString())));
        return matchedSegments;
    }

    private static void debugChecks(List<ActionBarSegment> matchedSegments, StyledText actionBarText) {
        List<ActionBarSegment> fallbackSegments = matchedSegments.stream().filter(segment -> segment instanceof FallbackSegment).toList();
        fallbackSegments.forEach(segment -> WynntilsMod.warn("Failed to match a portion of the action bar text, using a fallback: " + String.valueOf(segment)));
        if (!fallbackSegments.isEmpty()) {
            WynntilsMod.warn("Action bar text: " + actionBarText.getString());
        }
    }

    private static final class FallbackSegment
    extends ActionBarSegment {
        private FallbackSegment(String segmentText) {
            super(segmentText);
        }

        public String toString() {
            return "FallbackSegment{segmentText='" + this.segmentText + "'}";
        }
    }

    private static final class FallBackSegmentMatcher
    implements ActionBarSegmentMatcher {
        private FallBackSegmentMatcher() {
        }

        @Override
        public ActionBarSegment parse(String actionBar) {
            return new FallbackSegment(actionBar);
        }
    }
}

