/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.particle.type;

import com.wynntils.core.components.Handlers;
import com.wynntils.handlers.particle.type.Particle;
import com.wynntils.handlers.particle.type.ParticleType;
import com.wynntils.handlers.particle.type.ParticleVerifier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;

public class UnverifiedParticle {
    private final ParticleType particleType;
    private final ParticleOptions particleEffect;
    private final List<Position> particles = new ArrayList<Position>();

    public UnverifiedParticle(ParticleType particleType, ParticleOptions particleOptions) {
        this.particleType = particleType;
        this.particleEffect = particleOptions;
    }

    public boolean addNewParticle(Position newPosition, ParticleOptions newParticleOption) {
        if (newParticleOption != this.particleEffect) {
            return false;
        }
        if (Handlers.Particle.getParticleVerifier(this.particleType).verifyNewPosition(this.particles, newPosition)) {
            this.particles.add(newPosition);
            return true;
        }
        return false;
    }

    public ParticleVerifier.VerificationResult verifyCompleteness() {
        return Handlers.Particle.getParticleVerifier(this.particleType).verifyCompleteness(this.particles);
    }

    public ParticleOptions getParticleEffect() {
        return this.particleEffect;
    }

    public Particle getParticle() {
        return Handlers.Particle.getParticleVerifier(this.particleType).getParticle(this.particles);
    }
}

