/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.scoreboard;

import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.scoreboard.ScoreboardPart;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;

public final class ScoreboardSegment {
    private final ScoreboardPart scoreboardPart;
    private final StyledText header;
    private final List<StyledText> content;
    private boolean visible = true;

    public ScoreboardSegment(ScoreboardPart scoreboardPart, StyledText header, List<StyledText> content) {
        this.scoreboardPart = scoreboardPart;
        this.header = header;
        this.content = content;
    }

    public ScoreboardPart getScoreboardPart() {
        return this.scoreboardPart;
    }

    public StyledText getHeader() {
        return this.header;
    }

    public List<StyledText> getContent() {
        return this.content;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisibility(boolean visible) {
        this.visible = visible;
    }

    public String toString() {
        return "ScoreboardSegment{scoreboardPart=" + String.valueOf(this.scoreboardPart) + ", header='" + String.valueOf(this.header) + "', content=" + ArrayUtils.toString((Object)this.content.toArray()) + ", visible=" + this.visible + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScoreboardSegment segment = (ScoreboardSegment)o;
        return this.visible == segment.visible && Objects.equals(this.scoreboardPart, segment.scoreboardPart) && Objects.equals(this.header, segment.header) && Objects.deepEquals(this.content, segment.content);
    }

    public int hashCode() {
        return Objects.hash(this.scoreboardPart, this.header, this.content, this.visible);
    }
}

