/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.mc.mixin;

import com.wynntils.core.events.MixinHelper;
import com.wynntils.mc.event.DataComponentGetEvent;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.DyedItemColor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DataComponentHolder.class})
public interface DataComponentHolderMixin {
    @Inject(method={"get(Lnet/minecraft/core/component/DataComponentType;)Ljava/lang/Object;"}, at={@At(value="RETURN")}, cancellable=true)
    private void onGetComponent(DataComponentType<?> type, CallbackInfoReturnable<Object> cir) {
        DataComponentHolderMixin dataComponentHolderMixin = this;
        if (!(dataComponentHolderMixin instanceof ItemStack)) {
            return;
        }
        ItemStack stack = (ItemStack)dataComponentHolderMixin;
        Object original = cir.getReturnValue();
        DataComponentGetEvent event = null;
        if (type == DataComponents.CUSTOM_MODEL_DATA && original instanceof CustomModelData) {
            CustomModelData cmd = (CustomModelData)original;
            event = new DataComponentGetEvent.CustomModelData(stack, cmd);
        } else if (type == DataComponents.DYED_COLOR && original instanceof DyedItemColor) {
            DyedItemColor dye = (DyedItemColor)original;
            event = new DataComponentGetEvent.DyedItemColor(stack, dye);
        } else if (type == DataComponents.ENCHANTMENT_GLINT_OVERRIDE) {
            event = new DataComponentGetEvent.EnchantmentGlintOverride(stack, false);
        } else if (type == DataComponents.POTION_CONTENTS && original instanceof PotionContents) {
            PotionContents pc = (PotionContents)original;
            event = new DataComponentGetEvent.PotionContents(stack, pc);
        }
        if (event == null) {
            return;
        }
        MixinHelper.post(event);
        cir.setReturnValue(event.getValue());
    }
}

