/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.abilities;

import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.mc.event.AddEntityEvent;
import com.wynntils.mc.event.ChangeCarriedItemEvent;
import com.wynntils.mc.event.RemoveEntitiesEvent;
import com.wynntils.models.abilities.type.ArrowShield;
import com.wynntils.models.abilities.type.GuardianAngelsShield;
import com.wynntils.models.abilities.type.MantleShield;
import com.wynntils.models.abilities.type.ShieldType;
import com.wynntils.models.character.event.CharacterUpdateEvent;
import com.wynntils.models.spells.event.SpellEvent;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.utils.mc.McUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;

public final class ShieldModel
extends Model {
    private static final double SEARCH_RADIUS = 4.5;
    private final List<ShieldType> shieldTypes = new ArrayList<ShieldType>();
    private List<Integer> collectedIds;
    private List<Integer> spawnedIds;
    private long shieldCastTime = 0L;
    private ShieldType activeShieldType;

    public ShieldModel() {
        super(List.of());
        this.registerShieldTypes();
    }

    @SubscribeEvent
    public void onShieldCast(SpellEvent.Completed e) {
        for (ShieldType shieldType : this.shieldTypes) {
            if (!shieldType.validSpell(e.getSpell())) continue;
            this.shieldCastTime = System.currentTimeMillis();
            this.collectedIds = new ArrayList<Integer>();
            this.spawnedIds = null;
            break;
        }
    }

    @SubscribeEvent
    public void onShieldSpawn(AddEntityEvent event) {
        for (ShieldType shieldType : this.shieldTypes) {
            if (!shieldType.validClass()) continue;
            Entity entity = McUtils.mc().level.getEntity(event.getId());
            if (entity == null) {
                return;
            }
            if (!(entity instanceof ArmorStand)) {
                return;
            }
            ArmorStand shieldAS = (ArmorStand)entity;
            Vec3 playerPos = McUtils.player().position();
            Managers.TickScheduler.scheduleLater(() -> {
                if (!this.isValidSpawn()) {
                    return;
                }
                if (!shieldType.verifyShield(shieldAS)) {
                    return;
                }
                if (shieldAS.position().distanceTo(playerPos) > 4.5) {
                    return;
                }
                List<Integer> collector = this.collectedIds;
                if (collector == null) {
                    return;
                }
                collector.add(shieldAS.getId());
                this.activeShieldType = shieldType;
                Managers.TickScheduler.scheduleLater(this::registerShield, 2);
            }, 3);
        }
    }

    @SubscribeEvent
    public void onShieldDestroy(RemoveEntitiesEvent event) {
        if (this.spawnedIds == null) {
            return;
        }
        for (Integer destroyedEntityId : event.getEntityIds()) {
            this.spawnedIds.stream().filter(id -> Objects.equals(id, destroyedEntityId)).findFirst().ifPresent(id -> this.spawnedIds.remove(id));
        }
        if (this.spawnedIds.isEmpty()) {
            this.removeShield();
        }
    }

    @SubscribeEvent
    public void onClassChange(CharacterUpdateEvent e) {
        this.removeShield();
    }

    @SubscribeEvent
    public void onHeldItemChange(ChangeCarriedItemEvent e) {
        this.removeShield();
    }

    @SubscribeEvent
    public void onWorldStateChanged(WorldStateEvent e) {
        this.removeShield();
    }

    public int getShieldCharge() {
        return this.spawnedIds == null ? 0 : this.spawnedIds.size();
    }

    public ShieldType getActiveShieldType() {
        return this.activeShieldType;
    }

    private void registerShield() {
        if (this.collectedIds != null) {
            this.spawnedIds = this.collectedIds;
            this.collectedIds = null;
        }
    }

    private void removeShield() {
        this.spawnedIds = null;
        this.activeShieldType = null;
    }

    private boolean isValidSpawn() {
        return System.currentTimeMillis() - this.shieldCastTime < 200L || Models.Inventory.hasAutoCasterItem();
    }

    private void registerShieldTypes() {
        this.registerShieldType(new ArrowShield());
        this.registerShieldType(new GuardianAngelsShield());
        this.registerShieldType(new MantleShield());
    }

    private void registerShieldType(ShieldType shieldType) {
        this.shieldTypes.add(shieldType);
    }
}

