/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.activities.beacons;

import com.wynntils.core.text.StyledText;
import com.wynntils.models.activities.type.ActivityType;
import com.wynntils.models.beacons.type.BeaconMarkerKind;
import java.util.regex.Pattern;

public enum ActivityBeaconMarkerKind implements BeaconMarkerKind
{
    QUEST("\ue007", ActivityType.QUEST),
    STORYLINE_QUEST("\ue009", ActivityType.STORYLINE_QUEST),
    MINI_QUEST("\ue006", ActivityType.MINI_QUEST),
    WORLD_EVENT("\ue00a", ActivityType.WORLD_EVENT),
    DISCOVERY("\ue002", ActivityType.WORLD_DISCOVERY),
    CAVE("\ue003", ActivityType.CAVE),
    DUNGEON("\ue004", ActivityType.DUNGEON),
    RAID("\ue008", ActivityType.RAID),
    BOSS_ALTAR("\ue001", ActivityType.BOSS_ALTAR),
    LOOTRUN_CAMP("\ue005", ActivityType.LOOTRUN_CAMP);

    private static final String MARKER_PREFIX = "\udaff\udff8[\ue010-\ue014]\udaff\udfde";
    private static final String MARKER_SUFFIX = "\n(\\d+m (\u00a7[a-z0-9])?(\ue000|\ue001)?)?";
    private final ActivityType activityType;
    private final Pattern iconPattern;

    private ActivityBeaconMarkerKind(String iconCharacter, ActivityType activityType) {
        this.iconPattern = Pattern.compile(MARKER_PREFIX + iconCharacter + MARKER_SUFFIX);
        this.activityType = activityType;
    }

    @Override
    public boolean matches(StyledText styledText) {
        return styledText.matches(this.iconPattern);
    }

    public ActivityType getActivityType() {
        return this.activityType;
    }
}

