/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.activities.caves;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.activities.caves.CaveInfo;
import com.wynntils.models.activities.event.ActivityUpdatedEvent;
import com.wynntils.models.activities.type.ActivityDifficulty;
import com.wynntils.models.activities.type.ActivityDistance;
import com.wynntils.models.activities.type.ActivityInfo;
import com.wynntils.models.activities.type.ActivityLength;
import com.wynntils.models.activities.type.ActivitySortOrder;
import com.wynntils.models.activities.type.ActivityType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class CaveModel
extends Model {
    private final Map<String, CaveStorage> caveStorage = new HashMap<String, CaveStorage>();

    public CaveModel() {
        super(List.of());
    }

    public void reloadCaves() {
        WynntilsMod.info("Requesting rescan of caves in Activity Book");
        Models.Activity.scanContentBook(ActivityType.CAVE, this::updateCavesFromQuery);
    }

    private void updateCavesFromQuery(List<ActivityInfo> newActivities, List<StyledText> progress) {
        ArrayList<CaveInfo> newCaves = new ArrayList<CaveInfo>();
        for (ActivityInfo activity : newActivities) {
            if (activity.type() != ActivityType.CAVE) {
                WynntilsMod.warn("Incorrect cave activity type received: " + String.valueOf(activity));
                continue;
            }
            CaveInfo caveInfo = this.getCaveInfoFromActivity(activity);
            newCaves.add(caveInfo);
        }
        this.caveStorage.put(Models.Character.getId(), new CaveStorage(Collections.unmodifiableList(newCaves), Collections.unmodifiableList(progress)));
        WynntilsMod.postEvent(new ActivityUpdatedEvent(ActivityType.CAVE));
        WynntilsMod.info("Updated caves from query, got " + newCaves.size() + " caves.");
    }

    public Optional<CaveInfo> getCaveInfoFromName(String name) {
        return this.getCavesRaw().stream().filter(cave -> cave.name().equals(name)).findFirst();
    }

    public List<CaveInfo> getSortedCaves(ActivitySortOrder sortOrder) {
        return this.sortCaveInfoList(sortOrder, this.getCavesRaw());
    }

    private List<CaveInfo> sortCaveInfoList(ActivitySortOrder sortOrder, List<CaveInfo> caveList) {
        CaveInfo trackedCaveInfo = Models.Activity.getTrackedCaveInfo();
        String trackedCaveName = trackedCaveInfo != null ? trackedCaveInfo.name() : "";
        Comparator<CaveInfo> baseComparator = Comparator.comparing(caveInfo -> !caveInfo.name().equals(trackedCaveName));
        return switch (sortOrder) {
            default -> throw new MatchException(null, null);
            case ActivitySortOrder.LEVEL -> caveList.stream().sorted(baseComparator.thenComparing(CaveInfo::status).thenComparing(CaveInfo::recommendedLevel).thenComparing(CaveInfo::name)).toList();
            case ActivitySortOrder.DISTANCE -> caveList.stream().sorted(baseComparator.thenComparing(CaveInfo::status).thenComparing(CaveInfo::distance).thenComparing(CaveInfo::name)).toList();
            case ActivitySortOrder.ALPHABETIC -> caveList.stream().sorted(baseComparator.thenComparing(CaveInfo::status).thenComparing(CaveInfo::name).thenComparing(CaveInfo::recommendedLevel)).toList();
        };
    }

    public List<StyledText> getCaveProgress() {
        return Collections.unmodifiableList(this.caveStorage.getOrDefault(Models.Character.getId(), CaveStorage.EMPTY).progress());
    }

    private List<CaveInfo> getCavesRaw() {
        return Collections.unmodifiableList(this.caveStorage.getOrDefault(Models.Character.getId(), CaveStorage.EMPTY).caves());
    }

    public CaveInfo getCaveInfoFromActivity(ActivityInfo activity) {
        return new CaveInfo(activity.name(), activity.status(), activity.description().orElse(StyledText.EMPTY).getString(), activity.requirements().level().key(), activity.distance().orElse(ActivityDistance.NEAR), activity.length().orElse(ActivityLength.SHORT), activity.difficulty().orElse(ActivityDifficulty.EASY), activity.rewards());
    }

    private record CaveStorage(List<CaveInfo> caves, List<StyledText> progress) {
        public static final CaveStorage EMPTY = new CaveStorage(List.of(), List.of());
    }
}

