/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.beacons.event;

import com.wynntils.models.beacons.type.Beacon;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.Event;

public abstract class BeaconEvent
extends Event {
    protected final Beacon beacon;

    protected BeaconEvent(Beacon beacon) {
        this.beacon = beacon;
    }

    public Beacon getBeacon() {
        return this.beacon;
    }

    public static class Removed
    extends BeaconEvent {
        public Removed(Beacon beacon) {
            super(beacon);
        }
    }

    public static class Moved
    extends BeaconEvent {
        private final Beacon newBeacon;

        public Moved(Beacon oldBeacon, Beacon newBeacon) {
            super(oldBeacon);
            this.newBeacon = newBeacon;
        }

        @Override
        public Beacon getBeacon() {
            throw new UnsupportedOperationException("Use getOldBeacon() or getNewBeacon() instead");
        }

        public Beacon getOldBeacon() {
            return this.beacon;
        }

        public Beacon getNewBeacon() {
            return this.newBeacon;
        }
    }

    public static class Added
    extends BeaconEvent {
        private final Entity entity;

        public Added(Beacon verifiedBeacon, Entity entities) {
            super(verifiedBeacon);
            this.entity = entities;
        }

        public Entity getEntity() {
            return this.entity;
        }
    }
}

