/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.beacons.type;

import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.CustomModelData;

public interface BeaconKind {
    public CustomColor getCustomColor();

    public float getCustomModelData();

    default public boolean matches(ItemStack itemStack) {
        if (itemStack.getItem() != Items.POTION) {
            return false;
        }
        if (this.getCustomModelData() == -1.0f) {
            return false;
        }
        PotionContents potionContents = (PotionContents)itemStack.get(DataComponents.POTION_CONTENTS);
        if (potionContents == null) {
            return false;
        }
        CustomModelData potionCustomModelData = (CustomModelData)itemStack.get(DataComponents.CUSTOM_MODEL_DATA);
        if (potionCustomModelData == null) {
            return false;
        }
        Optional<Float> customModel = potionCustomModelData.floats().stream().filter(value -> value.equals(Float.valueOf(this.getCustomModelData()))).findFirst();
        if (customModel.isEmpty()) {
            return false;
        }
        int potionCustomColor = potionContents.customColor().orElse(CommonColors.WHITE.asInt());
        return this.getCustomColor().equals(CustomColor.fromInt(potionCustomColor));
    }
}

