/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.character;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.storage.Storage;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.container.scriptedquery.QueryStep;
import com.wynntils.handlers.container.scriptedquery.ScriptedContainerQuery;
import com.wynntils.handlers.container.type.ContainerContent;
import com.wynntils.handlers.container.type.ContainerContentChangeType;
import com.wynntils.models.character.type.SavableSkillPointSet;
import com.wynntils.models.elements.type.Skill;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.items.game.CraftedGearItem;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.models.items.items.game.TomeItem;
import com.wynntils.models.items.items.gui.SkillPointItem;
import com.wynntils.models.items.properties.GearTypeItemProperty;
import com.wynntils.models.stats.type.SkillStatType;
import com.wynntils.models.stats.type.StatType;
import com.wynntils.utils.mc.LoreUtils;
import com.wynntils.utils.wynn.ContainerUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public final class SkillPointModel
extends Model {
    @Persisted
    private final Storage<Map<String, SavableSkillPointSet>> skillPointLoadouts = new Storage(new TreeMap());
    private static final int TOME_SLOT = 8;
    private static final int[] SKILL_POINT_TOTAL_SLOTS = new int[]{11, 12, 13, 14, 15};
    private static final int SKILL_POINT_TOME_SLOT = 4;
    private static final int CONTENT_BOOK_SLOT = 62;
    private static final int TOME_MENU_CONTENT_BOOK_SLOT = 89;
    private Map<Skill, Integer> totalSkillPoints = new EnumMap<Skill, Integer>(Skill.class);
    private Map<Skill, Integer> gearSkillPoints = new EnumMap<Skill, Integer>(Skill.class);
    private Map<Skill, Integer> craftedSkillPoints = new EnumMap<Skill, Integer>(Skill.class);
    private Map<Skill, Integer> tomeSkillPoints = new EnumMap<Skill, Integer>(Skill.class);
    private Map<Skill, Integer> statusEffectSkillPoints = new EnumMap<Skill, Integer>(Skill.class);
    private Map<Skill, Integer> setBonusSkillPoints = new EnumMap<Skill, Integer>(Skill.class);
    private Map<Skill, Integer> assignedSkillPoints = new EnumMap<Skill, Integer>(Skill.class);

    public SkillPointModel() {
        super(List.of());
    }

    public boolean hasLoadout(String name) {
        return ((Map)this.skillPointLoadouts.get()).containsKey(name);
    }

    public void saveSkillPoints(String name, int[] skillPoints) {
        SavableSkillPointSet assignedSkillPointSet = new SavableSkillPointSet(skillPoints);
        ((Map)this.skillPointLoadouts.get()).put(name, assignedSkillPointSet);
        WynntilsMod.info("Saved skill point loadout: " + name + " " + String.valueOf(assignedSkillPointSet));
    }

    public void saveCurrentSkillPoints(String name) {
        this.saveSkillPoints(name, new int[]{this.getAssignedSkillPoints(Skill.STRENGTH), this.getAssignedSkillPoints(Skill.DEXTERITY), this.getAssignedSkillPoints(Skill.INTELLIGENCE), this.getAssignedSkillPoints(Skill.DEFENCE), this.getAssignedSkillPoints(Skill.AGILITY)});
    }

    public void saveBuild(String name, int[] skillPoints) {
        String weapon = null;
        ArrayList<String> armourNames = new ArrayList<String>();
        ArrayList<String> accessoryNames = new ArrayList<String>();
        for (ItemStack itemStack : Models.Inventory.getEquippedItems()) {
            WynnItem wynnItem;
            Optional<WynnItem> wynnItemOptional = Models.Item.getWynnItem(itemStack);
            if (wynnItemOptional.isEmpty() || !((wynnItem = wynnItemOptional.get()) instanceof GearTypeItemProperty)) continue;
            GearTypeItemProperty gear = (GearTypeItemProperty)((Object)wynnItem);
            if (gear.getGearType().isArmor()) {
                armourNames.add(StyledText.fromComponent(itemStack.getHoverName()).getString());
                continue;
            }
            if (gear.getGearType().isAccessory()) {
                accessoryNames.add(StyledText.fromComponent(itemStack.getHoverName()).getString());
                continue;
            }
            if (!gear.getGearType().isWeapon()) continue;
            weapon = StyledText.fromComponent(itemStack.getHoverName()).getString();
        }
        SavableSkillPointSet assignedSkillPointSet = new SavableSkillPointSet(skillPoints, weapon, armourNames, accessoryNames);
        ((Map)this.skillPointLoadouts.get()).put(name, assignedSkillPointSet);
        WynntilsMod.info("Saved skill point build: " + name + " " + String.valueOf(assignedSkillPointSet));
    }

    public void saveCurrentBuild(String name) {
        this.saveBuild(name, new int[]{this.getAssignedSkillPoints(Skill.STRENGTH), this.getAssignedSkillPoints(Skill.DEXTERITY), this.getAssignedSkillPoints(Skill.INTELLIGENCE), this.getAssignedSkillPoints(Skill.DEFENCE), this.getAssignedSkillPoints(Skill.AGILITY)});
    }

    public void deleteLoadout(String name) {
        ((Map)this.skillPointLoadouts.get()).remove(name);
    }

    public void loadLoadout(String name) {
        ContainerUtils.closeBackgroundContainer();
        ScriptedContainerQuery query = ScriptedContainerQuery.builder("Loading Skill Point Loadout Query").onError(msg -> WynntilsMod.warn("Failed to load skill point loadout: " + msg)).then(QueryStep.useItemInHotbar(7).expectContainerTitle("\udaff\udfdc\ue003").verifyContentChange((container, changes, changeType) -> this.verifyChange(container, (Int2ObjectFunction<ItemStack>)changes, changeType, 62)).processIncomingContainer(container -> this.loadSkillPointsOnServer(container, name))).build();
        query.executeQuery();
    }

    public void populateSkillPoints() {
        ContainerUtils.closeBackgroundContainer();
        Managers.TickScheduler.scheduleNextTick(() -> {
            this.assignedSkillPoints = new EnumMap<Skill, Integer>(Skill.class);
            this.calculateGearSkillPoints();
            this.calculateStatusEffectSkillPoints();
            this.queryTotalAndTomeSkillPoints();
        });
    }

    public int getTotalSkillPoints(Skill skill) {
        return this.totalSkillPoints.getOrDefault((Object)skill, 0);
    }

    public int getTotalSum() {
        return this.totalSkillPoints.values().stream().reduce(0, Integer::sum);
    }

    public int getGearSkillPoints(Skill skill) {
        return this.gearSkillPoints.getOrDefault((Object)skill, 0);
    }

    public int getGearSum() {
        return this.gearSkillPoints.values().stream().reduce(0, Integer::sum);
    }

    public int getCraftedSkillPoints(Skill skill) {
        return this.craftedSkillPoints.getOrDefault((Object)skill, 0);
    }

    public int getCraftedSum() {
        return this.craftedSkillPoints.values().stream().reduce(0, Integer::sum);
    }

    public int getTomeSkillPoints(Skill skill) {
        return this.tomeSkillPoints.getOrDefault((Object)skill, 0);
    }

    public int getTomeSum() {
        return this.tomeSkillPoints.values().stream().reduce(0, Integer::sum);
    }

    public int getStatusEffectSkillPoints(Skill skill) {
        return this.statusEffectSkillPoints.getOrDefault((Object)skill, 0);
    }

    public int getStatusEffectsSum() {
        return this.statusEffectSkillPoints.values().stream().reduce(0, Integer::sum);
    }

    public int getSetBonusSkillPoints(Skill skill) {
        return this.setBonusSkillPoints.getOrDefault((Object)skill, 0);
    }

    public int getSetBonusSum() {
        return this.setBonusSkillPoints.values().stream().reduce(0, Integer::sum);
    }

    public int getAssignedSkillPoints(Skill skill) {
        return this.assignedSkillPoints.getOrDefault((Object)skill, 0);
    }

    public int getAssignedSum() {
        return this.assignedSkillPoints.values().stream().reduce(0, Integer::sum);
    }

    public Map<String, SavableSkillPointSet> getLoadouts() {
        return (Map)this.skillPointLoadouts.get();
    }

    public boolean hasIllegalAssigned() {
        for (Skill skill : Skill.values()) {
            if (this.getAssignedSkillPoints(skill) >= 0 && this.getAssignedSkillPoints(skill) <= 100) continue;
            return true;
        }
        return false;
    }

    private void loadSkillPointsOnServer(ContainerContent containerContent, String name) {
        int i;
        int difference1s;
        int difference5s;
        EnumMap<Skill, Integer> negatives = new EnumMap<Skill, Integer>(Skill.class);
        EnumMap<Skill, Integer> positives = new EnumMap<Skill, Integer>(Skill.class);
        for (int i2 = 0; i2 < Skill.values().length; ++i2) {
            int buildTarget = ((SavableSkillPointSet)((Map)this.skillPointLoadouts.get()).get(name)).getSkillPointsAsArray()[i2];
            int difference = buildTarget - this.getAssignedSkillPoints(Skill.values()[i2]);
            if (difference > 0) {
                positives.put(Skill.values()[i2], difference);
                continue;
            }
            if (difference >= 0) continue;
            negatives.put(Skill.values()[i2], difference);
        }
        boolean confirmationCompleted = false;
        for (Map.Entry entry : negatives.entrySet()) {
            difference5s = Math.abs((Integer)entry.getValue()) / 5;
            difference1s = Math.abs((Integer)entry.getValue()) % 5;
            for (i = 0; i < difference5s; ++i) {
                ContainerUtils.shiftClickOnSlot(SKILL_POINT_TOTAL_SLOTS[((Skill)((Object)entry.getKey())).ordinal()], containerContent.containerId(), 1, containerContent.items());
                if (confirmationCompleted) continue;
                --i;
                confirmationCompleted = true;
            }
            for (i = 0; i < difference1s; ++i) {
                ContainerUtils.clickOnSlot(SKILL_POINT_TOTAL_SLOTS[((Skill)((Object)entry.getKey())).ordinal()], containerContent.containerId(), 1, containerContent.items());
                if (confirmationCompleted) continue;
                --i;
                confirmationCompleted = true;
            }
        }
        for (Map.Entry entry : positives.entrySet()) {
            difference5s = Math.abs((Integer)entry.getValue()) / 5;
            difference1s = Math.abs((Integer)entry.getValue()) % 5;
            for (i = 0; i < difference5s; ++i) {
                ContainerUtils.shiftClickOnSlot(SKILL_POINT_TOTAL_SLOTS[((Skill)((Object)entry.getKey())).ordinal()], containerContent.containerId(), 0, containerContent.items());
            }
            for (i = 0; i < difference1s; ++i) {
                ContainerUtils.clickOnSlot(SKILL_POINT_TOTAL_SLOTS[((Skill)((Object)entry.getKey())).ordinal()], containerContent.containerId(), 0, containerContent.items());
            }
        }
        Managers.TickScheduler.scheduleLater(this::populateSkillPoints, 4);
    }

    private void calculateGearSkillPoints() {
        this.gearSkillPoints = new EnumMap<Skill, Integer>(Skill.class);
        this.craftedSkillPoints = new EnumMap<Skill, Integer>(Skill.class);
        this.setBonusSkillPoints = new EnumMap<Skill, Integer>(Skill.class);
        for (ItemStack itemStack : Models.Inventory.getEquippedItems()) {
            this.calculateSingleGearSkillPoints(itemStack);
        }
        Models.Set.getUniqueSetNames().forEach(name -> {
            int trueCount = Models.Set.getTrueCount((String)name);
            Models.Set.getSetInfo((String)name).getBonusForItems(trueCount).forEach((bonus, value) -> {
                if (bonus instanceof SkillStatType) {
                    SkillStatType skillStat = (SkillStatType)bonus;
                    this.setBonusSkillPoints.merge(skillStat.getSkill(), (Integer)value, Integer::sum);
                }
            });
        });
    }

    private void calculateSingleGearSkillPoints(ItemStack itemStack) {
        Optional<WynnItem> wynnItemOptional = Models.Item.getWynnItem(itemStack);
        if (wynnItemOptional.isEmpty()) {
            return;
        }
        WynnItem wynnItem = wynnItemOptional.get();
        if (wynnItem instanceof GearItem) {
            GearItem gear = (GearItem)wynnItem;
            gear.getIdentifications().forEach(x -> {
                StatType patt0$temp = x.statType();
                if (patt0$temp instanceof SkillStatType) {
                    SkillStatType skillStat = (SkillStatType)patt0$temp;
                    this.gearSkillPoints.merge(skillStat.getSkill(), x.value(), Integer::sum);
                }
            });
        } else {
            wynnItem = wynnItemOptional.get();
            if (wynnItem instanceof CraftedGearItem) {
                CraftedGearItem craftedGear = (CraftedGearItem)wynnItem;
                craftedGear.getIdentifications().forEach(x -> {
                    StatType patt0$temp = x.statType();
                    if (patt0$temp instanceof SkillStatType) {
                        SkillStatType skillStat = (SkillStatType)patt0$temp;
                        this.craftedSkillPoints.merge(skillStat.getSkill(), x.value(), Integer::sum);
                    }
                });
            } else {
                WynntilsMod.warn("Skill Point Model failed to parse gear: " + String.valueOf(LoreUtils.getStringLore(itemStack)));
            }
        }
    }

    private void queryTotalAndTomeSkillPoints() {
        this.totalSkillPoints = new EnumMap<Skill, Integer>(Skill.class);
        this.tomeSkillPoints = new EnumMap<Skill, Integer>(Skill.class);
        ScriptedContainerQuery query = ScriptedContainerQuery.builder("Total and Tome Skill Point Query").onError(msg -> WynntilsMod.warn("Failed to query skill points: " + msg)).then(QueryStep.useItemInHotbar(7).expectContainerTitle("\udaff\udfdc\ue003").verifyContentChange((container, changes, changeType) -> this.verifyChange(container, (Int2ObjectFunction<ItemStack>)changes, changeType, 62)).processIncomingContainer(this::processTotalSkillPoints)).conditionalThen(this::checkTomesUnlocked, QueryStep.clickOnSlot(8).expectContainerTitle("\udaff\udfdb\ue005").verifyContentChange((container, changes, changeType) -> this.verifyChange(container, (Int2ObjectFunction<ItemStack>)changes, changeType, 89)).processIncomingContainer(this::processTomeSkillPoints)).execute(this::calculateAssignedSkillPoints).build();
        query.executeQuery();
    }

    private boolean checkTomesUnlocked(ContainerContent content) {
        return LoreUtils.getStringLore(content.items().get(8)).contains("\u2714");
    }

    private boolean verifyChange(ContainerContent content, Int2ObjectFunction<ItemStack> changes, ContainerContentChangeType changeType, int contentBookSlot) {
        return changeType == ContainerContentChangeType.SET_CONTENT && changes.containsKey(contentBookSlot) && content.items().get(contentBookSlot).getItem() == Items.POTION;
    }

    private void processTotalSkillPoints(ContainerContent content) {
        int[] nArray = SKILL_POINT_TOTAL_SLOTS;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            WynnItem wynnItem;
            Integer slot = nArray[i];
            Optional<WynnItem> wynnItemOptional = Models.Item.getWynnItem(content.items().get(slot));
            if (wynnItemOptional.isPresent() && (wynnItem = wynnItemOptional.get()) instanceof SkillPointItem) {
                SkillPointItem skillPoint = (SkillPointItem)wynnItem;
                this.totalSkillPoints.merge(skillPoint.getSkill(), skillPoint.getSkillPoints(), Integer::sum);
                continue;
            }
            WynntilsMod.warn("Skill Point Model failed to parse skill point item: " + String.valueOf(LoreUtils.getStringLore(content.items().get(slot))));
        }
    }

    private void processTomeSkillPoints(ContainerContent content) {
        WynnItem wynnItem;
        ItemStack itemStack = content.items().get(4);
        Optional<WynnItem> wynnItemOptional = Models.Item.getWynnItem(itemStack);
        if (wynnItemOptional.isPresent() && (wynnItem = wynnItemOptional.get()) instanceof TomeItem) {
            TomeItem tome = (TomeItem)wynnItem;
            tome.getIdentifications().forEach(x -> {
                StatType patt0$temp = x.statType();
                if (patt0$temp instanceof SkillStatType) {
                    SkillStatType skillStat = (SkillStatType)patt0$temp;
                    this.tomeSkillPoints.merge(skillStat.getSkill(), x.value(), Integer::sum);
                }
            });
        } else if (!LoreUtils.getStringLore(itemStack).contains("\u00a76Requirements:")) {
            WynntilsMod.warn("Skill Point Model failed to parse tome: " + String.valueOf(LoreUtils.getStringLore(content.items().get(4))));
        }
    }

    private void calculateStatusEffectSkillPoints() {
        this.statusEffectSkillPoints = new EnumMap<Skill, Integer>(Skill.class);
        Models.StatusEffect.getStatusEffects().forEach(statusEffect -> {
            for (Skill skill : Skill.values()) {
                if (!statusEffect.getName().contains(skill.getDisplayName())) continue;
                this.statusEffectSkillPoints.merge(skill, Integer.parseInt(statusEffect.getModifier().getStringWithoutFormatting()), Integer::sum);
            }
        });
    }

    private void calculateAssignedSkillPoints() {
        for (Skill skill : Skill.values()) {
            this.assignedSkillPoints.put(skill, this.getTotalSkillPoints(skill) - this.getGearSkillPoints(skill) - this.getSetBonusSkillPoints(skill) - this.getTomeSkillPoints(skill) - this.getCraftedSkillPoints(skill) - this.getStatusEffectSkillPoints(skill));
        }
    }
}

