/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.character.type;

public enum ClassType {
    MAGE("Mage", "Dark Wizard", 1, "\ue002", "\ue007"),
    ARCHER("Archer", "Hunter", 2, "\ue000", "\ue005"),
    WARRIOR("Warrior", "Knight", 3, "\ue004", "\ue009"),
    ASSASSIN("Assassin", "Ninja", 4, "\ue001", "\ue006"),
    SHAMAN("Shaman", "Skyseer", 5, "\ue003", "\ue008"),
    NONE("none", "none", 0, "", "");

    private final String name;
    private final String reskinnedName;
    private final int encodingId;
    private final String cardCharacter;
    private final String cardCharacterReskinned;

    private ClassType(String name, String reskinnedName, int encodingId, String cardCharacter, String cardCharacterReskinned) {
        this.name = name;
        this.reskinnedName = reskinnedName;
        this.encodingId = encodingId;
        this.cardCharacter = cardCharacter;
        this.cardCharacterReskinned = cardCharacterReskinned;
    }

    public static ClassType fromName(String className) {
        for (ClassType type : ClassType.values()) {
            if (!className.equalsIgnoreCase(type.name) && !className.equalsIgnoreCase(type.reskinnedName)) continue;
            return type;
        }
        return NONE;
    }

    public static boolean isReskinned(String className) {
        for (ClassType type : ClassType.values()) {
            if (className.equalsIgnoreCase(type.name)) {
                return false;
            }
            if (!className.equalsIgnoreCase(type.reskinnedName)) continue;
            return true;
        }
        return false;
    }

    public static ClassType fromCharacterSelectionCard(String character) {
        for (ClassType type : ClassType.values()) {
            if (!type.cardCharacter.equals(character) && !type.cardCharacterReskinned.equals(character)) continue;
            return type;
        }
        return NONE;
    }

    public static boolean isReskinnedCharacterSelection(ClassType classType, String character) {
        return classType.cardCharacterReskinned.equals(character);
    }

    public String getName() {
        return this.name;
    }

    private String getReskinnedName() {
        return this.reskinnedName;
    }

    public String getActualName(boolean isReskinned) {
        return isReskinned ? this.getReskinnedName() : this.getName();
    }

    public String getFullName() {
        return this.name + "/" + this.reskinnedName;
    }

    public int getEncodingId() {
        return this.encodingId;
    }

    public String toString() {
        return this.getFullName();
    }
}

