/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.characterstats.actionbar.matchers;

import com.wynntils.handlers.actionbar.ActionBarSegment;
import com.wynntils.handlers.actionbar.ActionBarSegmentMatcher;
import com.wynntils.utils.type.CappedValue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ExperienceSegmentMatcher
implements ActionBarSegmentMatcher {
    private static final String SEGMENT_START = "\udaff\udfa7";
    private static final String SEGMENT_END = "\udaff\udfa5";
    private final Pattern experienceBarPattern = Pattern.compile("\udaff\udfa7([" + this.getExperienceCharStart() + "-" + this.getExperienceCharEnd() + "])\udaff\udfa5");

    @Override
    public ActionBarSegment parse(String actionBar) {
        Matcher matcher = this.experienceBarPattern.matcher(actionBar);
        if (!matcher.find()) {
            return null;
        }
        String levelSegmentText = matcher.group(1);
        int startChar = this.getExperienceCharStart().codePointAt(0);
        int endChar = this.getExperienceCharEnd().codePointAt(0);
        int progress = levelSegmentText.codePointAt(0) - startChar;
        CappedValue cappedProgress = new CappedValue(progress, endChar - startChar + 1);
        return this.createExperienceSegment(matcher.group(), cappedProgress);
    }

    protected abstract String getExperienceCharStart();

    protected abstract String getExperienceCharEnd();

    protected abstract ActionBarSegment createExperienceSegment(String var1, CappedValue var2);
}

