/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.elements.type;

import com.wynntils.utils.StringUtils;
import net.minecraft.ChatFormatting;

public enum Element {
    EARTH("\ue001", ChatFormatting.DARK_GREEN, 0),
    THUNDER("\ue003", ChatFormatting.YELLOW, 1),
    WATER("\ue004", ChatFormatting.AQUA, 2),
    FIRE("\ue002", ChatFormatting.RED, 3),
    AIR("\ue000", ChatFormatting.WHITE, 4);

    private final String symbol;
    private final ChatFormatting colorCode;
    private final String displayName;
    private final int encodingId;

    private Element(String symbol, ChatFormatting colorCode, int encodingId) {
        this.symbol = symbol;
        this.colorCode = colorCode;
        this.encodingId = encodingId;
        this.displayName = StringUtils.capitalized(this.name());
    }

    public static Element fromSymbol(String symbol) {
        for (Element element : Element.values()) {
            if (!element.symbol.equals(symbol)) continue;
            return element;
        }
        return null;
    }

    public static Element fromEncodingId(int encodingId) {
        for (Element element : Element.values()) {
            if (element.encodingId != encodingId) continue;
            return element;
        }
        return null;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public ChatFormatting getColorCode() {
        return this.colorCode;
    }

    public int getEncodingId() {
        return this.encodingId;
    }
}

