/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.guild.type;

import com.wynntils.models.territories.type.GuildResource;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;

public class DiplomacyInfo {
    private final Map<GuildResource, Integer> sentTributes = new EnumMap<GuildResource, Integer>(GuildResource.class);
    private final Map<GuildResource, Integer> receivedTributes = new EnumMap<GuildResource, Integer>(GuildResource.class);
    private final String alliedGuildName;

    public DiplomacyInfo(String alliedGuildName) {
        this.alliedGuildName = alliedGuildName;
    }

    public String getAlliedGuildName() {
        return this.alliedGuildName;
    }

    public Map<GuildResource, Integer> getSentTributes() {
        return Collections.unmodifiableMap(this.sentTributes);
    }

    public Map<GuildResource, Integer> getReceivedTributes() {
        return Collections.unmodifiableMap(this.receivedTributes);
    }

    public void storeSentTribute(GuildResource resource, int amount) {
        this.sentTributes.put(resource, amount);
    }

    public void storeReceivedTribute(GuildResource resource, int amount) {
        this.receivedTributes.put(resource, amount);
    }

    public void removeSentTribute(GuildResource resource) {
        this.sentTributes.remove((Object)resource);
    }

    public void removeReceivedTribute(GuildResource resource) {
        this.receivedTributes.remove((Object)resource);
    }
}

