/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.inventory;

import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.ContainerSetContentEvent;
import com.wynntils.mc.event.SetSlotEvent;
import com.wynntils.models.inventory.InventoryWatcher;
import com.wynntils.models.inventory.type.InventoryAccessory;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.models.items.items.game.IngredientItem;
import com.wynntils.models.items.items.game.MaterialItem;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.models.worlds.type.WorldState;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.type.CappedValue;
import com.wynntils.utils.wynn.ItemUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;

public final class InventoryModel
extends Model {
    private static final int MAX_INVENTORY_SLOTS = 29;
    private static final List<String> AUTO_CASTER_MAJOR_IDS = List.of("Sorcery", "Madness");
    private final InventoryWatcher emptySlotWatcher = new InventoryWatcher(ItemStack::isEmpty);
    private final List<InventoryWatcher> watchers = new ArrayList<InventoryWatcher>(List.of(this.emptySlotWatcher));

    public InventoryModel() {
        super(List.of());
    }

    public CappedValue getInventorySlots() {
        return new CappedValue(29 - this.getEmptySlots(), 29);
    }

    public void registerWatcher(InventoryWatcher watcher) {
        this.watchers.add(watcher);
        this.updateCache();
    }

    public void unregisterWatcher(InventoryWatcher watcher) {
        this.watchers.remove(watcher);
    }

    public List<ItemStack> getEquippedItems() {
        ArrayList<ItemStack> returnable = new ArrayList<ItemStack>((Collection<ItemStack>)McUtils.inventory().armor);
        Collections.reverse(returnable);
        for (int i : InventoryAccessory.getSlots()) {
            ItemStack accessory;
            int baseSize = 0;
            if (McUtils.player().hasContainerOpen()) {
                baseSize = McUtils.player().containerMenu.getItems().size();
            }
            if (ItemUtils.isEmptyAccessorySlot(accessory = McUtils.inventory().getItem(i + baseSize))) continue;
            returnable.add(McUtils.inventory().getItem(i + baseSize));
        }
        Optional<GearItem> handItemOpt = Models.Item.asWynnItem(McUtils.player().getItemInHand(InteractionHand.MAIN_HAND), GearItem.class);
        if (handItemOpt.isPresent() && handItemOpt.get().meetsActualRequirements() && handItemOpt.get().getGearType().isWeapon()) {
            returnable.add(McUtils.player().getItemInHand(InteractionHand.MAIN_HAND));
        }
        return returnable.stream().filter(itemStack -> !itemStack.isEmpty()).toList();
    }

    public boolean hasAutoCasterItem() {
        for (ItemStack item : this.getEquippedItems()) {
            GearItem gearItem;
            Optional<GearItem> gearItemOpt = Models.Item.asWynnItem(item, GearItem.class);
            if (gearItemOpt.isEmpty() || !(gearItem = gearItemOpt.get()).getItemInfo().fixedStats().majorIds().stream().anyMatch(majorId -> AUTO_CASTER_MAJOR_IDS.contains(majorId.name()))) continue;
            return true;
        }
        return Models.Raid.getRaidMajorIds(McUtils.mc().getUser().getName()).stream().anyMatch(AUTO_CASTER_MAJOR_IDS::contains);
    }

    public int getAmountInInventory(String name) {
        int amount = 0;
        for (ItemStack itemStack : McUtils.inventory().items) {
            StyledText itemName = StyledText.fromComponent(itemStack.getHoverName()).getNormalized().trim();
            if (!itemName.getString().endsWith(name)) continue;
            amount += itemStack.getCount();
        }
        return amount;
    }

    public int getIngredientAmountInInventory(String name) {
        return McUtils.inventory().items.stream().filter(itemStack -> {
            Optional<IngredientItem> ingredientItem = Models.Item.asWynnItem((ItemStack)itemStack, IngredientItem.class);
            if (ingredientItem.isEmpty()) {
                return false;
            }
            return ingredientItem.get().getName().startsWith(name);
        }).mapToInt(itemStack -> itemStack.count).sum();
    }

    public int getMaterialsAmountInInventory(String name, int tier, boolean exact) {
        return McUtils.inventory().items.stream().filter(itemStack -> {
            Optional<MaterialItem> materialItemOpt = Models.Item.asWynnItem((ItemStack)itemStack, MaterialItem.class);
            if (materialItemOpt.isEmpty()) {
                return false;
            }
            MaterialItem materialItem = materialItemOpt.get();
            if (!itemStack.getHoverName().getString().startsWith(name)) {
                return false;
            }
            return exact ? materialItem.getQualityTier() == tier : materialItem.getQualityTier() >= tier;
        }).mapToInt(itemStack -> itemStack.count).sum();
    }

    @SubscribeEvent
    public void onWorldChange(WorldStateEvent e) {
        if (e.getNewState() == WorldState.WORLD) {
            this.updateCache();
        } else {
            this.resetCache();
        }
    }

    @SubscribeEvent
    public void onContainerSetEvent(ContainerSetContentEvent.Post e) {
        if (e.getContainerId() == McUtils.inventoryMenu().containerId) {
            this.updateCache();
        }
    }

    @SubscribeEvent
    public void onSlotSetEvent(SetSlotEvent.Post e) {
        if (Objects.equals(e.getContainer(), McUtils.inventory())) {
            this.updateCache();
        }
    }

    private int getEmptySlots() {
        return this.emptySlotWatcher.getSlots();
    }

    private void updateCache() {
        Inventory inventory = McUtils.inventory();
        this.watchers.forEach(watcher -> {
            int slots = 0;
            int totalCount = 0;
            for (ItemStack itemStack : inventory.items) {
                if (!watcher.shouldInclude(itemStack)) continue;
                ++slots;
                totalCount += itemStack.getCount();
            }
            if (slots != watcher.getSlots() || totalCount != watcher.getTotalCount()) {
                watcher.updateFromModel(slots, totalCount);
            }
        });
    }

    private void resetCache() {
        this.watchers.forEach(watcher -> watcher.updateFromModel(0, 0));
    }
}

