/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items;

import com.wynntils.core.components.Handlers;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.tooltip.TooltipBuilder;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.models.items.properties.CraftedItemProperty;
import com.wynntils.models.items.properties.IdentifiableItemProperty;
import com.wynntils.models.items.properties.NamedItemProperty;
import com.wynntils.utils.mc.TooltipUtils;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;

public class FakeItemStack
extends ItemStack {
    private final WynnItem wynnItem;
    private final String source;

    public FakeItemStack(WynnItem wynnItem, ItemStack itemStack, String source) {
        super((ItemLike)itemStack.getItem(), 1);
        this.applyComponents(itemStack.getComponentsPatch());
        if (wynnItem instanceof NamedItemProperty) {
            NamedItemProperty namedItemProperty = (NamedItemProperty)((Object)wynnItem);
            Handlers.Item.updateItem(this, wynnItem, StyledText.fromString(namedItemProperty.getName()));
        }
        this.wynnItem = wynnItem;
        this.source = source;
    }

    public FakeItemStack(GearItem gearItem, String source) {
        this(gearItem, gearItem.getItemInfo().metaInfo().material().itemStack(), source);
    }

    public FakeItemStack(WynnItem wynnItem, String source) {
        this(wynnItem, new ItemStack((ItemLike)Items.STONE), source);
    }

    public List<Component> getTooltipLines(Item.TooltipContext context, Player player, TooltipFlag isAdvanced) {
        TooltipBuilder tooltipBuilder = null;
        WynnItem wynnItem = this.wynnItem;
        if (wynnItem instanceof IdentifiableItemProperty) {
            IdentifiableItemProperty identifiableItem = (IdentifiableItemProperty)((Object)wynnItem);
            tooltipBuilder = this.wynnItem.getData().getOrCalculate("tooltip", () -> Handlers.Tooltip.buildNew(identifiableItem, false, true, this.source));
        } else {
            wynnItem = this.wynnItem;
            if (wynnItem instanceof CraftedItemProperty) {
                CraftedItemProperty craftedItemProperty = (CraftedItemProperty)((Object)wynnItem);
                tooltipBuilder = this.wynnItem.getData().getOrCalculate("tooltip", () -> Handlers.Tooltip.buildNew(craftedItemProperty, this.source));
            }
        }
        if (tooltipBuilder == null) {
            return List.of();
        }
        return TooltipUtils.getWynnItemTooltip(this, this.wynnItem);
    }
}

