/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.encoding.impl.item;

import com.wynntils.models.elements.type.Element;
import com.wynntils.models.elements.type.Powder;
import com.wynntils.models.gear.type.GearAttackSpeed;
import com.wynntils.models.gear.type.GearRequirements;
import com.wynntils.models.gear.type.GearType;
import com.wynntils.models.items.encoding.data.CustomGearTypeData;
import com.wynntils.models.items.encoding.data.CustomIdentificationsData;
import com.wynntils.models.items.encoding.data.DamageData;
import com.wynntils.models.items.encoding.data.DefenseData;
import com.wynntils.models.items.encoding.data.DurabilityData;
import com.wynntils.models.items.encoding.data.NameData;
import com.wynntils.models.items.encoding.data.PowderData;
import com.wynntils.models.items.encoding.data.RequirementsData;
import com.wynntils.models.items.encoding.type.EncodingSettings;
import com.wynntils.models.items.encoding.type.ItemData;
import com.wynntils.models.items.encoding.type.ItemDataMap;
import com.wynntils.models.items.encoding.type.ItemTransformer;
import com.wynntils.models.items.encoding.type.ItemType;
import com.wynntils.models.items.items.game.CraftedGearItem;
import com.wynntils.models.stats.type.DamageType;
import com.wynntils.models.stats.type.StatActualValue;
import com.wynntils.models.stats.type.StatPossibleValues;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.type.CappedValue;
import com.wynntils.utils.type.ErrorOr;
import com.wynntils.utils.type.Pair;
import com.wynntils.utils.type.RangedValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class CraftedGearItemTransformer
extends ItemTransformer<CraftedGearItem> {
    @Override
    public ErrorOr<CraftedGearItem> decodeItem(ItemDataMap itemDataMap) {
        PowderData powderData;
        CustomIdentificationsData identificationsData;
        DefenseData defenseData;
        GearAttackSpeed attackSpeed = null;
        int health = 0;
        ArrayList<Pair<DamageType, RangedValue>> damages = new ArrayList();
        ArrayList<Pair<Element, Integer>> defences = new ArrayList();
        ArrayList<StatPossibleValues> possibleValues = new ArrayList();
        ArrayList<StatActualValue> identifications = new ArrayList();
        int powderSlots = 0;
        ArrayList<Powder> powders = new ArrayList();
        CustomGearTypeData gearTypeData = itemDataMap.get(CustomGearTypeData.class);
        if (gearTypeData == null) {
            return ErrorOr.error("Crafted gear item does not have gear type data!");
        }
        GearType gearType = gearTypeData.gearType();
        DurabilityData durabilityData = itemDataMap.get(DurabilityData.class);
        if (durabilityData == null) {
            return ErrorOr.error("Crafted gear item does not have durability data!");
        }
        int effectStrength = durabilityData.effectStrength();
        CappedValue durability = durabilityData.durability();
        RequirementsData requirementsData = itemDataMap.get(RequirementsData.class);
        if (requirementsData == null) {
            return ErrorOr.error("Crafted gear item does not have requirements data!");
        }
        GearRequirements requirements = requirementsData.requirements();
        NameData nameData = itemDataMap.get(NameData.class);
        Object name = nameData != null && nameData.name().isPresent() ? nameData.name().get() : "Crafted " + StringUtils.capitalizeFirst(gearTypeData.gearType().name().toLowerCase(Locale.ROOT));
        DamageData damageData = itemDataMap.get(DamageData.class);
        if (damageData != null && damageData.attackSpeed().isPresent()) {
            attackSpeed = damageData.attackSpeed().get();
            damages = damageData.damages();
        }
        if ((defenseData = itemDataMap.get(DefenseData.class)) != null) {
            health = defenseData.health();
            defences = defenseData.defences();
        }
        if ((identificationsData = itemDataMap.get(CustomIdentificationsData.class)) != null) {
            possibleValues = identificationsData.possibleValues();
            identifications = identificationsData.possibleValues().stream().map(statPossibleValues -> new StatActualValue(statPossibleValues.statType(), Math.round((float)(statPossibleValues.range().high() * effectStrength) / 100.0f), 0, RangedValue.NONE)).toList();
        }
        if ((powderData = itemDataMap.get(PowderData.class)) != null) {
            powderSlots = powderData.powderSlots();
            powders = powderData.powders().stream().map(Pair::a).toList();
        }
        return ErrorOr.of(new CraftedGearItem((String)name, effectStrength, gearType, attackSpeed, health, damages, defences, requirements, possibleValues, identifications, powders, powderSlots, false, durability));
    }

    @Override
    protected List<ItemData> encodeItem(CraftedGearItem item, EncodingSettings encodingSettings) {
        ArrayList<ItemData> dataList = new ArrayList<ItemData>();
        dataList.add(new CustomGearTypeData(item.getGearType()));
        dataList.add(new DurabilityData(item.getEffectStrength(), item.getDurability()));
        dataList.add(new RequirementsData(item.getRequirements()));
        if (encodingSettings.shareItemName()) {
            dataList.add(NameData.sanitized(item.getName()));
        }
        dataList.add(new DamageData(item.getAttackSpeed(), item.getDamages()));
        dataList.add(new DefenseData(item.getHealth(), item.getDefences()));
        dataList.add(new CustomIdentificationsData(item.getPossibleValues()));
        dataList.add(PowderData.from(item));
        return dataList;
    }

    @Override
    public ItemType getType() {
        return ItemType.CRAFTED_GEAR;
    }
}

