/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.lootrun;

import com.google.common.reflect.TypeToken;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.core.json.JsonManager;
import com.wynntils.core.net.DownloadRegistry;
import com.wynntils.core.net.UrlId;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.storage.Storage;
import com.wynntils.core.text.StyledText;
import com.wynntils.features.combat.CustomLootrunBeaconsFeature;
import com.wynntils.handlers.chat.event.ChatMessageEvent;
import com.wynntils.handlers.chat.type.RecipientType;
import com.wynntils.handlers.labels.event.LabelIdentifiedEvent;
import com.wynntils.handlers.labels.type.LabelInfo;
import com.wynntils.handlers.particle.event.ParticleVerifiedEvent;
import com.wynntils.handlers.particle.type.ParticleType;
import com.wynntils.mc.event.ContainerClickEvent;
import com.wynntils.mc.event.MenuEvent;
import com.wynntils.mc.event.ScreenInitEvent;
import com.wynntils.mc.event.SetEntityDataEvent;
import com.wynntils.mc.extension.EntityExtension;
import com.wynntils.models.beacons.event.BeaconEvent;
import com.wynntils.models.beacons.event.BeaconMarkerEvent;
import com.wynntils.models.beacons.type.Beacon;
import com.wynntils.models.beacons.type.BeaconMarker;
import com.wynntils.models.beacons.type.BeaconMarkerKind;
import com.wynntils.models.character.event.CharacterUpdateEvent;
import com.wynntils.models.containers.Container;
import com.wynntils.models.containers.containers.LootrunRewardChestContainer;
import com.wynntils.models.containers.event.ValuableFoundEvent;
import com.wynntils.models.gear.type.GearTier;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.models.items.items.game.InsulatorItem;
import com.wynntils.models.items.items.game.SimulatorItem;
import com.wynntils.models.lootrun.beacons.LootrunBeaconKind;
import com.wynntils.models.lootrun.beacons.LootrunBeaconMarkerKind;
import com.wynntils.models.lootrun.event.LootrunBeaconSelectedEvent;
import com.wynntils.models.lootrun.event.LootrunFinishedEventBuilder;
import com.wynntils.models.lootrun.markers.LootrunBeaconMarkerProvider;
import com.wynntils.models.lootrun.particle.LootrunTaskParticleVerifier;
import com.wynntils.models.lootrun.scoreboard.LootrunScoreboardPart;
import com.wynntils.models.lootrun.type.LootrunDetails;
import com.wynntils.models.lootrun.type.LootrunLocation;
import com.wynntils.models.lootrun.type.LootrunTaskType;
import com.wynntils.models.lootrun.type.LootrunningState;
import com.wynntils.models.lootrun.type.MissionType;
import com.wynntils.models.lootrun.type.TaskLocation;
import com.wynntils.models.lootrun.type.TaskPrediction;
import com.wynntils.models.lootrun.type.TrialType;
import com.wynntils.models.marker.MarkerModel;
import com.wynntils.models.npc.label.NpcLabelInfo;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.models.worlds.type.WorldState;
import com.wynntils.utils.VectorUtils;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.LoreUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.PosUtils;
import com.wynntils.utils.mc.type.Location;
import com.wynntils.utils.type.CappedValue;
import com.wynntils.utils.type.Pair;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public final class LootrunModel
extends Model {
    private static final Pattern LOOTRUN_COMPLETED_PATTERN = Pattern.compile("\udb00\udc62\u00a76\u00a7lLootrun Completed!");
    private static final Pattern REWARD_PULLS_PATTERN = Pattern.compile("\u00a7.(\\d+)\u00a77 Reward Pulls\u00a7r");
    private static final Pattern REWARD_REROLLS_PATTERN = Pattern.compile("\u00a7.(\\d+)\u00a77 Reward Rerolls\u00a7r");
    private static final Pattern REWARD_SACRIFICES_PATTERN = Pattern.compile("\u00a7.(\\d+)\u00a77 Reward Sacrifices\u00a7r");
    private static final Pattern LOOTRUN_EXPERIENCE_PATTERN = Pattern.compile("\u00a7.(\\d+)\u00a77 Lootrun Experience\u00a7r");
    private static final Pattern TIME_ELAPSED_PATTERN = Pattern.compile("\u00a77Time Elapsed: \u00a7.(\\d+):(\\d+)");
    private static final Pattern MOBS_KILLED_PATTERN = Pattern.compile("\u00a77Mobs Killed: \u00a7.(\\d+)");
    private static final Pattern CHESTS_OPENED_PATTERN = Pattern.compile("\u00a77Chests Open: \u00a7.(\\d+)");
    private static final Pattern CHALLENGES_COMPLETED_PATTERN = Pattern.compile("\u00a77Challenges Completed: \u00a7.(\\d+)");
    private static final Pattern LOOTRUN_FAILED_PATTERN = Pattern.compile("\udb00\udc6d\u00a7c\u00a7lLootrun Failed!");
    private static final Pattern CHALLENGE_COMPLETED_PATTERN = Pattern.compile("\udb00\udc5e\u00a7a\u00a7lChallenge Completed");
    private static final Pattern CHALLENGE_FAILED_PATTERN = Pattern.compile("\udb00\udc68\u00a7c\u00a7lChallenge Failed!");
    private static final Pattern CHOOSE_BEACON_PATTERN = Pattern.compile("\udb00\udc66\u00a76\u00a7lChoose a Beacon!");
    private static final Pattern BEACONS_PATTERN = Pattern.compile("[\udaff\udfff-\udb00\udc78]\u00a7(?<beaconOneColor>[a-z0-9#]+)\u00a7l(?<beaconOneVibrant>Vibrant )?.+? Beacon(\u00a7r[\udaff\udfff-\udb00\udc78]\u00a7(?<beaconTwoColor>[a-z0-9#]+)\u00a7l(?<beaconTwoVibrant>Vibrant )?.+ Beacon)?");
    private static final Pattern ORANGE_AMOUNT_PATTERN = Pattern.compile(".+\u00a77(?:.+?)?for (?:\u00a7b)?(\\d+)(?:\u00a7r)? Challenges");
    private static final Pattern RAINBOW_AMOUNT_PATTERN = Pattern.compile(".+\u00a77(?:.+?)?next (?:\u00a7b)?(\\d+)(\u00a7(r|7))? Challenges");
    private static final Pattern MISSION_COMPLETED_PATTERN = Pattern.compile("(?:[^\u0000-\u007f]+)?\u00a7b\u00a7lMission Completed");
    private static final Pattern COMPLETED_MISSION_PATTERN = Pattern.compile("(?:[^\\u0000-\\u007F]+)?\u00a7.(?<mission>" + MissionType.missionTypes().stream().map(MissionType::getName).collect(Collectors.joining("|")) + ")");
    private static final Pattern ACTIVE_MISSION_PATTERN = Pattern.compile("[\u00c0\\s]*?\u00a7b\u00a7l(?<mission>" + MissionType.missionTypes().stream().map(MissionType::getName).collect(Collectors.joining("|")) + ")");
    private static final Pattern TRIAL_STARTED_PATTERN = Pattern.compile("\udb00\udc6d\u00a7b\u00a7lTrial Started");
    private static final Pattern TRIAL_NAME_PATTERN = Pattern.compile("(?:.+)?\u00a77(?<trial>" + TrialType.trialTypes().stream().map(TrialType::getName).collect(Collectors.joining("|")) + ")");
    private static final Pattern CHALLENGE_GET_SACRIFICE_PATTERN = Pattern.compile("\\[\\+(\\d+) Reward Sacrifices?\\]");
    private static final Pattern CHALLENGE_GET_REROLL_PATTERN = Pattern.compile("\\[\\+(\\d+) Reward Rerolls?\\]");
    private static final float BEACON_REMOVAL_RADIUS = 25.0f;
    private static final int TASK_POSITION_ERROR = 3;
    private static final int TASK_DISTANCE_ERROR = 15;
    private static final int MARKER_DISTANCE_THRESHOLD = 17;
    private static final int LOOTRUN_MASTER_REWARDS_RADIUS = 20;
    private static final String LOOTRUN_MASTER_NAME = "Lootrun Master";
    private static final LootrunScoreboardPart LOOTRUN_SCOREBOARD_PART = new LootrunScoreboardPart();
    private static final LootrunBeaconMarkerProvider LOOTRUN_BEACON_COMPASS_PROVIDER = new LootrunBeaconMarkerProvider();
    @Persisted
    public final Storage<Integer> dryPulls = new Storage<Integer>(0);
    @Persisted
    private final Storage<Integer> expectedPulls = new Storage<Integer>(-1);
    private final Set<UUID> checkedItemEntities = new HashSet<UUID>();
    private Location closestLootrunMasterLocation = null;
    private boolean foundLootrunMythic = false;
    private boolean rerollingRewards = false;
    private boolean rewardChestIsOpened = false;
    private Map<LootrunLocation, Set<TaskLocation>> taskLocations = new HashMap<LootrunLocation, Set<TaskLocation>>();
    private LootrunFinishedEventBuilder.Completed lootrunCompletedBuilder;
    private LootrunFinishedEventBuilder.Failed lootrunFailedBuilder;
    private LootrunningState lootrunningState = LootrunningState.NOT_RUNNING;
    private LootrunTaskType taskType;
    private Map<LootrunBeaconKind, TaskPrediction> beacons = new HashMap<LootrunBeaconKind, TaskPrediction>();
    private Set<LootrunBeaconKind> vibrantBeacons = new HashSet<LootrunBeaconKind>();
    private Set<TaskLocation> possibleTaskLocations = new HashSet<TaskLocation>();
    private int timeLeft = 0;
    private CappedValue challenges = CappedValue.EMPTY;
    private boolean expectMissionComplete = false;
    private boolean expectTrialStarted = false;
    private boolean expectOrangeBeacon = false;
    private boolean expectRainbowBeacon = false;
    @Persisted
    private final Storage<Map<String, LootrunDetails>> lootrunDetailsStorage = new Storage(new TreeMap());
    private List<Pair<Beacon<LootrunBeaconKind>, EntityExtension>> activeBeacons = new ArrayList<Pair<Beacon<LootrunBeaconKind>, EntityExtension>>();
    private Map<LootrunBeaconKind, LootrunTaskType> activeTaskTypes = new HashMap<LootrunBeaconKind, LootrunTaskType>();

    public LootrunModel(MarkerModel markerModel) {
        super(List.of(markerModel));
        Handlers.Scoreboard.addPart(LOOTRUN_SCOREBOARD_PART);
        Handlers.Particle.registerParticleVerifier(ParticleType.LOOTRUN_TASK, new LootrunTaskParticleVerifier());
        Models.Marker.registerMarkerProvider(LOOTRUN_BEACON_COMPASS_PROVIDER);
        for (LootrunBeaconKind lootrunBeaconKind : LootrunBeaconKind.values()) {
            Models.Beacon.registerBeacon(lootrunBeaconKind);
        }
        for (Enum enum_ : LootrunBeaconMarkerKind.values()) {
            Models.Beacon.registerBeaconMarker((BeaconMarkerKind)((Object)enum_));
        }
    }

    @Override
    public void registerDownloads(DownloadRegistry registry) {
        registry.registerDownload(UrlId.DATA_STATIC_LOOTRUN_TASKS_NAMED_V2).handleReader(this::handleLootrunTaskLocations);
    }

    private void handleLootrunTaskLocations(Reader reader) {
        Type type = new TypeToken<Map<LootrunLocation, Set<TaskLocation>>>(){}.getType();
        this.taskLocations = (Map)JsonManager.GSON.fromJson(reader, type);
    }

    @SubscribeEvent
    public void onLootrunParticle(ParticleVerifiedEvent event) {
        if (event.getParticle().particleType() != ParticleType.LOOTRUN_TASK) {
            return;
        }
        boolean foundTaskLocation = false;
        for (Set<TaskLocation> taskLocationsForLocation : this.taskLocations.values()) {
            for (TaskLocation taskLocation2 : taskLocationsForLocation) {
                if (!PosUtils.closerThanIgnoringY((Position)taskLocation2.location().toVec3(), event.getParticle().position(), 3.0)) continue;
                this.possibleTaskLocations.add(new TaskLocation(taskLocation2.name(), Location.containing(event.getParticle().position()), taskLocation2.taskType()));
                foundTaskLocation = true;
                break;
            }
            if (!foundTaskLocation) continue;
            break;
        }
        if (!foundTaskLocation) {
            Location location = Location.containing(event.getParticle().position());
            this.possibleTaskLocations.add(new TaskLocation(location.toString(), location, LootrunTaskType.UNKNOWN));
        }
        if (!WynntilsMod.isDevelopmentEnvironment()) {
            return;
        }
        for (LootrunLocation location : LootrunLocation.values()) {
            List<TaskLocation> tasksInLocation = this.possibleTaskLocations.stream().filter(taskLocation -> this.taskLocations.getOrDefault((Object)location, Set.of()).contains(taskLocation)).toList();
            if (tasksInLocation.isEmpty() || tasksInLocation.size() >= this.possibleTaskLocations.size()) continue;
            List<TaskLocation> tasksNotInLocation = this.possibleTaskLocations.stream().filter(taskLocation -> !tasksInLocation.contains(taskLocation)).toList();
            WynntilsMod.warn("Found tasks from multiple locations: " + String.valueOf(this.possibleTaskLocations));
            WynntilsMod.warn("Task location is: " + String.valueOf((Object)location));
            WynntilsMod.warn("Tasks in location: " + String.valueOf(tasksInLocation));
            WynntilsMod.warn("Tasks outside location: " + String.valueOf(tasksNotInLocation));
            break;
        }
    }

    @SubscribeEvent
    public void onCharacterChange(CharacterUpdateEvent event) {
        String id = Models.Character.getId();
        ((Map)this.lootrunDetailsStorage.get()).putIfAbsent(id, new LootrunDetails());
        this.lootrunDetailsStorage.touched();
    }

    @SubscribeEvent
    public void onChatMessage(ChatMessageEvent.Match event) {
        Matcher rainbowMatcher;
        Matcher orangeMatcher;
        if (event.getRecipientType() != RecipientType.INFO) {
            return;
        }
        StyledText styledText = event.getMessage();
        if (styledText.matches(LOOTRUN_COMPLETED_PATTERN)) {
            this.lootrunCompletedBuilder = new LootrunFinishedEventBuilder.Completed();
            this.lootrunFailedBuilder = null;
            return;
        }
        if (styledText.matches(LOOTRUN_FAILED_PATTERN)) {
            this.lootrunFailedBuilder = new LootrunFinishedEventBuilder.Failed();
            this.lootrunCompletedBuilder = null;
            return;
        }
        if (this.lootrunCompletedBuilder != null) {
            this.parseCompletedMessages(styledText);
        } else if (this.lootrunFailedBuilder != null) {
            this.parseFailedMessages(styledText);
        }
        Matcher matcher = MISSION_COMPLETED_PATTERN.matcher(styledText.getString());
        if (matcher.matches()) {
            this.expectMissionComplete = true;
            return;
        }
        if (this.expectMissionComplete && (matcher = COMPLETED_MISSION_PATTERN.matcher(styledText.getString())).matches()) {
            MissionType mission = MissionType.fromName(matcher.group("mission"));
            this.addMission(mission);
            return;
        }
        matcher = ACTIVE_MISSION_PATTERN.matcher(styledText.getString());
        if (matcher.find()) {
            MissionType mission = MissionType.fromName(matcher.group("mission"));
            this.addMission(mission);
            return;
        }
        matcher = TRIAL_STARTED_PATTERN.matcher(styledText.getString());
        if (matcher.find()) {
            this.expectTrialStarted = true;
            return;
        }
        if (this.expectTrialStarted) {
            matcher = TRIAL_NAME_PATTERN.matcher(styledText.getString());
            if (matcher.find()) {
                TrialType trial = TrialType.fromName(matcher.group("trial"));
                this.addTrial(trial);
            }
            this.expectTrialStarted = false;
            return;
        }
        matcher = CHALLENGE_GET_SACRIFICE_PATTERN.matcher(styledText.getString());
        if (matcher.find()) {
            int amount = Integer.parseInt(matcher.group(1));
            LootrunDetails details = this.getCurrentLootrunDetails();
            details.setSacrifices(details.getSacrifices() + amount);
            this.lootrunDetailsStorage.touched();
            return;
        }
        matcher = CHALLENGE_GET_REROLL_PATTERN.matcher(styledText.getString());
        if (matcher.find()) {
            int amount = Integer.parseInt(matcher.group(1));
            LootrunDetails details = this.getCurrentLootrunDetails();
            details.setRerolls(details.getRerolls() + amount);
            this.lootrunDetailsStorage.touched();
            return;
        }
        matcher = CHALLENGE_COMPLETED_PATTERN.matcher(styledText.getString());
        if (matcher.matches()) {
            this.challengeCompleted();
            return;
        }
        matcher = CHALLENGE_FAILED_PATTERN.matcher(styledText.getString());
        if (matcher.matches()) {
            this.challengeFailed();
            return;
        }
        matcher = styledText.getMatcher(BEACONS_PATTERN);
        if (matcher.matches()) {
            boolean beaconTwoVibrant;
            boolean beaconOneVibrant;
            String beaconOneColorStr = matcher.group("beaconOneColor");
            CustomColor beaconOneColor = beaconOneColorStr.startsWith("#") ? CustomColor.fromHexString(beaconOneColorStr) : CustomColor.fromChatFormatting(ChatFormatting.getByCode((char)beaconOneColorStr.charAt(0)));
            LootrunBeaconKind beaconOneKind = LootrunBeaconKind.fromColor(beaconOneColor);
            if (beaconOneKind == null) {
                return;
            }
            boolean bl = beaconOneVibrant = matcher.group("beaconOneVibrant") != null;
            if (beaconOneVibrant) {
                this.vibrantBeacons.add(beaconOneKind);
            }
            this.expectOrangeBeacon = this.expectOrangeBeacon || beaconOneKind == LootrunBeaconKind.ORANGE;
            this.expectRainbowBeacon = this.expectRainbowBeacon || beaconOneKind == LootrunBeaconKind.RAINBOW;
            String beaconTwoColorStr = matcher.group("beaconTwoColor");
            if (beaconTwoColorStr == null) {
                return;
            }
            CustomColor beaconTwoColor = beaconTwoColorStr.startsWith("#") ? CustomColor.fromHexString(beaconTwoColorStr) : CustomColor.fromChatFormatting(ChatFormatting.getByCode((char)beaconTwoColorStr.charAt(0)));
            LootrunBeaconKind beaconTwoKind = LootrunBeaconKind.fromColor(beaconTwoColor);
            if (beaconTwoKind == null) {
                return;
            }
            boolean bl2 = beaconTwoVibrant = matcher.group("beaconTwoVibrant") != null;
            if (beaconTwoVibrant) {
                this.vibrantBeacons.add(beaconTwoKind);
            }
            this.expectOrangeBeacon = this.expectOrangeBeacon || beaconTwoKind == LootrunBeaconKind.ORANGE;
            this.expectRainbowBeacon = this.expectRainbowBeacon || beaconTwoKind == LootrunBeaconKind.RAINBOW;
            return;
        }
        if (styledText.matches(CHOOSE_BEACON_PATTERN)) {
            this.newBeacons();
            return;
        }
        if (this.expectOrangeBeacon && (orangeMatcher = styledText.getMatcher(ORANGE_AMOUNT_PATTERN)).find()) {
            this.expectOrangeBeacon = false;
            this.getCurrentLootrunDetails().setOrangeAmount(Integer.parseInt(orangeMatcher.group(1)));
            this.lootrunDetailsStorage.touched();
        }
        if (this.expectRainbowBeacon && (rainbowMatcher = styledText.getMatcher(RAINBOW_AMOUNT_PATTERN)).find()) {
            this.expectRainbowBeacon = false;
            this.getCurrentLootrunDetails().setRainbowAmount(Integer.parseInt(rainbowMatcher.group(1)));
            this.lootrunDetailsStorage.touched();
        }
    }

    @SubscribeEvent
    public void onNpcLabelFound(LabelIdentifiedEvent event) {
        NpcLabelInfo npcLabelInfo;
        LabelInfo labelInfo = event.getLabelInfo();
        if (labelInfo instanceof NpcLabelInfo && (npcLabelInfo = (NpcLabelInfo)labelInfo).getName().equals(LOOTRUN_MASTER_NAME)) {
            this.closestLootrunMasterLocation = event.getLabelInfo().getLocation();
        }
    }

    @SubscribeEvent
    public void onEntitySpawn(SetEntityDataEvent event) {
        int idToCheck;
        Entity entity = McUtils.mc().level.getEntity(event.getId());
        if (entity instanceof ItemEntity) {
            idToCheck = ItemEntity.DATA_ITEM.id();
        } else if (entity instanceof Display.ItemDisplay) {
            idToCheck = Display.ItemDisplay.DATA_ITEM_STACK_ID.id();
        } else {
            return;
        }
        if (this.closestLootrunMasterLocation == null) {
            return;
        }
        if (this.closestLootrunMasterLocation.toBlockPos().distSqr((Vec3i)entity.blockPosition()) > Math.pow(20.0, 2.0)) {
            return;
        }
        if (this.checkedItemEntities.contains(entity.getUUID())) {
            return;
        }
        this.checkedItemEntities.add(entity.getUUID());
        for (SynchedEntityData.DataValue<?> packedItem : event.getPackedItems()) {
            Optional<SimulatorItem> simulatorItemOpt;
            Optional<InsulatorItem> insulatorItemOpt;
            GearItem gearItem;
            if (packedItem.id() != idToCheck) continue;
            Object object = packedItem.value();
            if (!(object instanceof ItemStack)) {
                return;
            }
            ItemStack itemStack = (ItemStack)object;
            boolean foundMythic = false;
            Optional<GearItem> gearItemOpt = Models.Item.asWynnItem(itemStack, GearItem.class);
            if (gearItemOpt.isPresent() && (gearItem = gearItemOpt.get()).getGearTier() == GearTier.MYTHIC) {
                foundMythic = true;
            }
            if ((insulatorItemOpt = Models.Item.asWynnItem(itemStack, InsulatorItem.class)).isPresent()) {
                foundMythic = true;
            }
            if ((simulatorItemOpt = Models.Item.asWynnItem(itemStack, SimulatorItem.class)).isPresent()) {
                foundMythic = true;
            }
            if (!foundMythic) continue;
            this.foundLootrunMythic = true;
            WynntilsMod.postEvent(new ValuableFoundEvent(itemStack, ValuableFoundEvent.ItemSource.LOOTRUN_REWARD_CHEST));
        }
    }

    @SubscribeEvent
    public void onScreenInit(ScreenInitEvent.Pre e) {
        Container container = Models.Container.getCurrentContainer();
        if (container instanceof LootrunRewardChestContainer) {
            LootrunRewardChestContainer lootrunRewardChestContainer = (LootrunRewardChestContainer)container;
            this.checkedItemEntities.clear();
            this.rewardChestIsOpened = true;
        } else {
            this.rewardChestIsOpened = false;
        }
    }

    @SubscribeEvent
    public void onMenuClosed(MenuEvent.MenuClosedEvent event) {
        if (!this.rewardChestIsOpened) {
            return;
        }
        if (!this.rerollingRewards) {
            return;
        }
        if ((Integer)this.expectedPulls.get() == -1) {
            WynntilsMod.warn("[LootrunModel] Failed to update dry lootrun count after closing the reward chest. Did not detect number of expected pulls. Got expectedPulls=" + String.valueOf(this.expectedPulls.get()) + ".");
            return;
        }
        if (this.foundLootrunMythic) {
            this.dryPulls.store((Integer)this.expectedPulls.get());
        } else {
            this.dryPulls.store((Integer)this.dryPulls.get() + (Integer)this.expectedPulls.get());
        }
        this.rewardChestIsOpened = false;
        this.rerollingRewards = false;
    }

    @SubscribeEvent
    public void onSlotClicked(ContainerClickEvent e) {
        if (e.getItemStack().isEmpty()) {
            return;
        }
        Container container = Models.Container.getCurrentContainer();
        if (container instanceof LootrunRewardChestContainer) {
            LootrunRewardChestContainer lootrunRewardChestContainer = (LootrunRewardChestContainer)container;
            if (LootrunRewardChestContainer.REROLL_REWARDS_SLOTS.contains(e.getSlotNum())) {
                StyledText rerollLoreConfirm = LoreUtils.getLore(e.getItemStack()).getFirst();
                if (rerollLoreConfirm.matches(LootrunRewardChestContainer.REROLL_CONFIRM_PATTERN)) {
                    this.rerollingRewards = true;
                    this.checkedItemEntities.clear();
                }
            } else if (e.getSlotNum() == 4) {
                StyledText itemName = StyledText.fromComponent(e.getItemStack().getHoverName());
                if (!itemName.equals(LootrunRewardChestContainer.CLOSE_CHEST_ITEM_NAME)) {
                    return;
                }
                if ((Integer)this.expectedPulls.get() == -1) {
                    WynntilsMod.warn("[LootrunModel] Failed to update dry lootrun count after closing the reward chest. Did not detect number of expected pulls. Got expectedPulls=" + String.valueOf(this.expectedPulls.get()) + ". Probably, the player tried closing the chest before, which got cancelled and the contents of the chest got refreshed.");
                    return;
                }
                if (this.foundLootrunMythic) {
                    this.dryPulls.store(0);
                } else {
                    this.dryPulls.store((Integer)this.dryPulls.get() + (Integer)this.expectedPulls.get());
                }
                this.expectedPulls.store(-1);
                this.rewardChestIsOpened = false;
            }
        }
    }

    @SubscribeEvent
    public void onWorldStateChanged(WorldStateEvent event) {
        if (event.getNewState() == WorldState.WORLD) {
            return;
        }
        this.lootrunCompletedBuilder = null;
        this.lootrunFailedBuilder = null;
        this.possibleTaskLocations = new HashSet<TaskLocation>();
        this.lootrunningState = LootrunningState.NOT_RUNNING;
        this.taskType = null;
        this.beacons = new HashMap<LootrunBeaconKind, TaskPrediction>();
        this.activeBeacons = new ArrayList<Pair<Beacon<LootrunBeaconKind>, EntityExtension>>();
        this.activeTaskTypes = new HashMap<LootrunBeaconKind, LootrunTaskType>();
        LOOTRUN_BEACON_COMPASS_PROVIDER.reloadTaskMarkers();
        this.challenges = CappedValue.EMPTY;
        this.timeLeft = 0;
    }

    @SubscribeEvent
    public void onBeaconRemove(BeaconEvent.Removed event) {
        double oldBeaconDistanceToPlayer;
        Beacon beacon = event.getBeacon();
        Object t = beacon.beaconKind();
        if (!(t instanceof LootrunBeaconKind)) {
            return;
        }
        LootrunBeaconKind lootrunBeaconKind = (LootrunBeaconKind)t;
        Beacon closestBeacon = this.getClosestBeacon();
        double newBeaconDistanceToPlayer = VectorUtils.distanceIgnoringY(beacon.position(), (Position)McUtils.mc().player.position());
        double d = oldBeaconDistanceToPlayer = closestBeacon == null ? Double.MAX_VALUE : (double)VectorUtils.distanceIgnoringY(closestBeacon.position(), (Position)McUtils.mc().player.position());
        if (newBeaconDistanceToPlayer < 25.0 && newBeaconDistanceToPlayer <= oldBeaconDistanceToPlayer) {
            this.setClosestBeacon(event.getBeacon());
        } else {
            this.beacons.remove(lootrunBeaconKind);
            LOOTRUN_BEACON_COMPASS_PROVIDER.reloadTaskMarkers();
        }
        this.activeBeacons.removeIf(beaconPair -> ((Beacon)beaconPair.a()).beaconKind() == lootrunBeaconKind);
    }

    @SubscribeEvent
    public void onBeaconAdded(BeaconEvent.Added event) {
        Beacon beacon = event.getBeacon();
        if (!(beacon.beaconKind() instanceof LootrunBeaconKind)) {
            return;
        }
        EntityExtension entity = (EntityExtension)event.getEntity();
        CustomLootrunBeaconsFeature feature = Managers.Feature.getFeatureInstance(CustomLootrunBeaconsFeature.class);
        if (((Boolean)feature.removeOriginalBeacons.get()).booleanValue() && feature.isEnabled()) {
            entity.setRendered(false);
        }
        this.activeBeacons.add(Pair.of(beacon, entity));
    }

    @SubscribeEvent
    public void onBeaconMoved(BeaconEvent.Moved event) {
        Beacon beacon = event.getNewBeacon();
        Object t = beacon.beaconKind();
        if (!(t instanceof LootrunBeaconKind)) {
            return;
        }
        LootrunBeaconKind lootrunBeaconKind = (LootrunBeaconKind)t;
        Pair<Beacon<LootrunBeaconKind>, EntityExtension> oldPair = null;
        for (Pair<Beacon<LootrunBeaconKind>, EntityExtension> activeBeacon : this.activeBeacons) {
            if (activeBeacon.a().beaconKind() != lootrunBeaconKind) continue;
            oldPair = activeBeacon;
            break;
        }
        if (oldPair == null) {
            return;
        }
        Pair<Beacon, EntityExtension> newPair = Pair.of(beacon, (EntityExtension)oldPair.b());
        this.activeBeacons.remove(oldPair);
        this.activeBeacons.add(newPair);
    }

    @SubscribeEvent
    public void onBeaconMarkerAdded(BeaconMarkerEvent.Added event) {
        boolean shouldHide;
        BeaconMarker beaconMarker = event.getBeaconMarker();
        BeaconMarkerKind beaconMarkerKind = beaconMarker.beaconMarkerKind();
        if (!(beaconMarkerKind instanceof LootrunBeaconMarkerKind)) {
            return;
        }
        LootrunBeaconMarkerKind lootrunMarker = (LootrunBeaconMarkerKind)beaconMarkerKind;
        EntityExtension entity = (EntityExtension)event.getEntity();
        CustomLootrunBeaconsFeature feature = Managers.Feature.getFeatureInstance(CustomLootrunBeaconsFeature.class);
        boolean bl = shouldHide = (Boolean)feature.removeOriginalBeacons.get() != false && feature.isEnabled();
        if (shouldHide) {
            entity.setRendered(false);
        }
        if (beaconMarker.distance().isEmpty()) {
            if (event.getEntity().position().distanceTo(McUtils.player().position()) >= 17.0) {
                WynntilsMod.warn("Lootrun beacon has no distance");
                entity.setRendered(true);
            }
            return;
        }
        if (beaconMarker.color().isEmpty()) {
            WynntilsMod.warn("Lootrun beacon has no color");
            entity.setRendered(true);
            return;
        }
        Pair<Beacon<LootrunBeaconKind>, EntityExtension> beaconPair = null;
        for (Pair<Beacon<LootrunBeaconKind>, EntityExtension> activeBeacon : this.activeBeacons) {
            if (!activeBeacon.a().beaconKind().getCustomColor().equals(beaconMarker.color().get())) continue;
            beaconPair = activeBeacon;
            break;
        }
        if (beaconPair == null) {
            entity.setRendered(true);
            return;
        }
        this.activeTaskTypes.putIfAbsent((LootrunBeaconKind)((Beacon)beaconPair.a()).beaconKind(), lootrunMarker.getTaskType());
        boolean foundBeacon = this.updateTaskLocationPrediction((Beacon)beaconPair.a(), lootrunMarker, beaconMarker.distance().get()) || this.beacons.containsKey(beaconPair.a().beaconKind());
        entity.setRendered(!foundBeacon || !shouldHide);
        beaconPair.b().setRendered(!foundBeacon || !shouldHide);
    }

    public void toggleBeacons(boolean visible) {
        for (Pair<Beacon<LootrunBeaconKind>, EntityExtension> beaconPair : this.activeBeacons) {
            if (!this.beacons.containsKey(beaconPair.a().beaconKind())) continue;
            beaconPair.b().setRendered(!visible);
        }
    }

    public int getBeaconCount(LootrunBeaconKind color) {
        return this.getCurrentLootrunDetails().getSelectedBeacons().getOrDefault(color, 0);
    }

    public String getMissionStatus(int index, boolean colored) {
        List<MissionType> missions = this.getCurrentLootrunDetails().getMissions();
        if (index < 0 || index >= missions.size()) {
            return colored ? MissionType.UNKNOWN.getColoredName() : MissionType.UNKNOWN.getName();
        }
        MissionType mission = this.getCurrentLootrunDetails().getMissions().get(index);
        return colored ? mission.getColoredName() : mission.getName();
    }

    public String getTrial(int index) {
        List<TrialType> trials = this.getCurrentLootrunDetails().getTrials();
        if (index < 0 || index >= trials.size()) {
            return TrialType.UNKNOWN.getName();
        }
        TrialType trial = this.getCurrentLootrunDetails().getTrials().get(index);
        return trial.getName();
    }

    public LootrunningState getState() {
        return this.lootrunningState;
    }

    public Optional<LootrunTaskType> getTaskType() {
        return Optional.ofNullable(this.taskType);
    }

    public Map<LootrunBeaconKind, TaskPrediction> getBeacons() {
        return Collections.unmodifiableMap(this.beacons);
    }

    public boolean isBeaconVibrant(LootrunBeaconKind lootrunBeaconKind) {
        return this.vibrantBeacons.contains(lootrunBeaconKind);
    }

    public TaskLocation getTaskForColor(LootrunBeaconKind lootrunBeaconKind) {
        TaskPrediction taskPrediction = this.beacons.get(lootrunBeaconKind);
        if (taskPrediction == null) {
            return null;
        }
        return taskPrediction.taskLocation();
    }

    public void setState(LootrunningState newState, LootrunTaskType taskType) {
        if (this.lootrunningState == newState) {
            return;
        }
        LootrunningState oldState = this.lootrunningState;
        this.lootrunningState = newState;
        this.taskType = taskType;
        this.handleStateChange(oldState, newState);
    }

    public int getCurrentTime() {
        return this.timeLeft;
    }

    public CappedValue getChallenges() {
        return this.challenges;
    }

    public LootrunBeaconKind getLastTaskBeaconColor() {
        return this.getCurrentLootrunDetails().getLastTaskBeaconColor();
    }

    public boolean wasLastBeaconVibrant() {
        return this.getCurrentLootrunDetails().getLastTaskVibrantBeacon();
    }

    public Beacon getClosestBeacon() {
        return this.getCurrentLootrunDetails().getClosestBeacon();
    }

    public int getRedBeaconTaskCount() {
        return this.getCurrentLootrunDetails().getRedBeaconTaskCount();
    }

    public int getActiveOrangeBeacons() {
        return this.getCurrentLootrunDetails().getOrangeBeaconCounts().size();
    }

    public int getSacrifices() {
        return this.getCurrentLootrunDetails().getSacrifices();
    }

    public int getRerolls() {
        return this.getCurrentLootrunDetails().getRerolls();
    }

    public int getChallengesTillNextOrangeExpires() {
        List<Integer> orangeBeaconCounts = this.getCurrentLootrunDetails().getOrangeBeaconCounts();
        if (orangeBeaconCounts.isEmpty()) {
            return 0;
        }
        return Collections.min(orangeBeaconCounts);
    }

    public int getActiveRainbowBeacons() {
        return this.getCurrentLootrunDetails().getRainbowBeaconCount();
    }

    private void setLastTaskBeaconColor(LootrunBeaconKind lootrunBeaconKind) {
        this.getCurrentLootrunDetails().setLastTaskBeaconColor(lootrunBeaconKind);
        this.getCurrentLootrunDetails().setLastTaskVibrantBeacon(this.vibrantBeacons.contains(lootrunBeaconKind));
        this.lootrunDetailsStorage.touched();
    }

    private void setClosestBeacon(Beacon beacon) {
        this.getCurrentLootrunDetails().setClosestBeacon(beacon);
        this.lootrunDetailsStorage.touched();
    }

    private void resetBeaconStorage() {
        this.getCurrentLootrunDetails().setSelectedBeacons(new TreeMap<LootrunBeaconKind, Integer>());
        this.lootrunDetailsStorage.touched();
    }

    private void resetSacrifices() {
        this.getCurrentLootrunDetails().setSacrifices(0);
        this.lootrunDetailsStorage.touched();
    }

    private void resetRerolls() {
        this.getCurrentLootrunDetails().setRerolls(0);
        this.lootrunDetailsStorage.touched();
    }

    private void newBeacons() {
        this.possibleTaskLocations.clear();
        this.vibrantBeacons.clear();
        this.getCurrentLootrunDetails().setOrangeAmount(-1);
        this.getCurrentLootrunDetails().setRainbowAmount(-1);
        this.lootrunDetailsStorage.touched();
        this.expectOrangeBeacon = false;
        this.expectRainbowBeacon = false;
    }

    private void addToRedBeaconTaskCount(int changeAmount) {
        int oldCount = this.getCurrentLootrunDetails().getRedBeaconTaskCount();
        int newCount = Math.max(oldCount + changeAmount, 0);
        this.getCurrentLootrunDetails().setRedBeaconTaskCount(newCount);
        this.lootrunDetailsStorage.touched();
    }

    private void resetBeaconCounts() {
        this.getCurrentLootrunDetails().setRedBeaconTaskCount(0);
        this.getCurrentLootrunDetails().setOrangeBeaconCounts(new ArrayList<Integer>());
        this.getCurrentLootrunDetails().setRainbowBeaconCount(0);
        this.lootrunDetailsStorage.touched();
    }

    private void resetMissions() {
        this.getCurrentLootrunDetails().setMissions(new ArrayList<MissionType>());
        this.lootrunDetailsStorage.touched();
    }

    private void addMission(MissionType mission) {
        int sacrifices;
        int rerolls;
        if (!this.getCurrentLootrunDetails().getMissions().contains((Object)mission)) {
            this.getCurrentLootrunDetails().addMission(mission);
        }
        if ((rerolls = mission.getRerolls()) > 0) {
            this.getCurrentLootrunDetails().setRerolls(this.getCurrentLootrunDetails().getRerolls() + rerolls);
        }
        if ((sacrifices = mission.getSacrifices()) > 0) {
            this.getCurrentLootrunDetails().setSacrifices(this.getCurrentLootrunDetails().getSacrifices() + sacrifices);
        }
        this.lootrunDetailsStorage.touched();
        this.expectMissionComplete = false;
    }

    private void resetTrials() {
        this.getCurrentLootrunDetails().setTrials(new ArrayList<TrialType>());
        this.lootrunDetailsStorage.touched();
    }

    private void addTrial(TrialType trial) {
        if (!this.getCurrentLootrunDetails().getTrials().contains((Object)trial)) {
            this.getCurrentLootrunDetails().addTrial(trial);
        }
        this.lootrunDetailsStorage.touched();
    }

    public void setTimeLeft(int seconds) {
        this.timeLeft = seconds;
    }

    public void setChallenges(CappedValue amount) {
        CappedValue oldChallenges = this.challenges;
        this.challenges = amount;
        if (oldChallenges == CappedValue.EMPTY) {
            return;
        }
        if (amount.current() > oldChallenges.current()) {
            this.addToRedBeaconTaskCount(-1);
        }
        if (this.getLastTaskBeaconColor() == LootrunBeaconKind.RED && amount.max() > oldChallenges.max()) {
            this.addToRedBeaconTaskCount(amount.max() - oldChallenges.max());
        }
    }

    private void handleStateChange(LootrunningState oldState, LootrunningState newState) {
        Object t;
        if (newState == LootrunningState.NOT_RUNNING) {
            this.resetBeaconStorage();
            this.resetMissions();
            this.resetTrials();
            this.taskType = null;
            this.setClosestBeacon(null);
            this.setLastTaskBeaconColor(null);
            this.resetBeaconCounts();
            this.resetSacrifices();
            this.resetRerolls();
            this.possibleTaskLocations = new HashSet<TaskLocation>();
            this.beacons = new HashMap<LootrunBeaconKind, TaskPrediction>();
            this.vibrantBeacons = new HashSet<LootrunBeaconKind>();
            this.timeLeft = 0;
            this.challenges = CappedValue.EMPTY;
            return;
        }
        Beacon closestBeacon = this.getClosestBeacon();
        if (oldState == LootrunningState.CHOOSING_BEACON && newState == LootrunningState.IN_TASK && closestBeacon != null && (t = closestBeacon.beaconKind()) instanceof LootrunBeaconKind) {
            LootrunBeaconKind color = (LootrunBeaconKind)t;
            WynntilsMod.info("Selected a " + String.valueOf(color) + " beacon at " + String.valueOf(closestBeacon.position()));
            this.getCurrentLootrunDetails().incrementBeaconCount(color);
            this.lootrunDetailsStorage.touched();
            this.setLastTaskBeaconColor(color);
            WynntilsMod.postEvent(new LootrunBeaconSelectedEvent(closestBeacon, this.beacons.get(closestBeacon.beaconKind()).taskLocation(), this.activeTaskTypes.getOrDefault(closestBeacon.beaconKind(), LootrunTaskType.UNKNOWN)));
            this.possibleTaskLocations = new HashSet<TaskLocation>();
            this.beacons.clear();
            this.vibrantBeacons.clear();
            this.activeBeacons.clear();
            this.activeTaskTypes.clear();
            this.setClosestBeacon(null);
            this.expectOrangeBeacon = false;
            this.expectRainbowBeacon = false;
            this.reduceBeaconCounts();
            LOOTRUN_BEACON_COMPASS_PROVIDER.reloadTaskMarkers();
            return;
        }
    }

    private void challengeCompleted() {
        LootrunBeaconKind color = this.getLastTaskBeaconColor();
        LootrunDetails lootrunDetails = this.getCurrentLootrunDetails();
        if (color == LootrunBeaconKind.RAINBOW) {
            if (lootrunDetails.getRainbowAmount() != -1) {
                int oldCount = lootrunDetails.getRainbowBeaconCount();
                int newCount = Math.max(oldCount + lootrunDetails.getRainbowAmount(), 0);
                lootrunDetails.setRainbowBeaconCount(newCount);
            } else {
                WynntilsMod.warn("Completed rainbow beacon challenge but had no rainbow amount");
            }
        } else if (color == LootrunBeaconKind.ORANGE) {
            if (lootrunDetails.getOrangeAmount() != -1) {
                ArrayList<Integer> orangeList = new ArrayList<Integer>(this.getCurrentLootrunDetails().getOrangeBeaconCounts());
                orangeList.add(lootrunDetails.getOrangeAmount());
                lootrunDetails.setOrangeBeaconCounts(orangeList);
            } else {
                WynntilsMod.warn("Completed orange beacon challenge but had no orange amount");
            }
        }
        lootrunDetails.setOrangeAmount(-1);
        lootrunDetails.setRainbowAmount(-1);
        ((Map)this.lootrunDetailsStorage.get()).put(Models.Character.getId(), lootrunDetails);
    }

    private void challengeFailed() {
        LootrunBeaconKind color = this.getLastTaskBeaconColor();
        if (color == LootrunBeaconKind.GRAY) {
            this.addMission(MissionType.FAILED);
        }
        if (color == LootrunBeaconKind.CRIMSON) {
            this.addTrial(TrialType.FAILED);
        }
        this.getCurrentLootrunDetails().setOrangeAmount(-1);
        this.getCurrentLootrunDetails().setRainbowAmount(-1);
        this.lootrunDetailsStorage.touched();
    }

    private void reduceBeaconCounts() {
        LootrunDetails lootrunDetails = this.getCurrentLootrunDetails();
        int oldRainbowCount = lootrunDetails.getRainbowBeaconCount();
        if (oldRainbowCount > 0) {
            int newCount = oldRainbowCount - 1;
            lootrunDetails.setRainbowBeaconCount(newCount);
        }
        List<Integer> orangeCounts = this.getOrangeCounts(lootrunDetails);
        lootrunDetails.setOrangeBeaconCounts(orangeCounts);
        ((Map)this.lootrunDetailsStorage.get()).put(Models.Character.getId(), lootrunDetails);
    }

    private List<Integer> getOrangeCounts(LootrunDetails lootrunDetails) {
        ArrayList<Integer> orangeCounts = new ArrayList<Integer>(lootrunDetails.getOrangeBeaconCounts());
        if (!orangeCounts.isEmpty()) {
            ListIterator<Integer> orangeIterator = orangeCounts.listIterator();
            while (orangeIterator.hasNext()) {
                int currentOrangeCount = (Integer)orangeIterator.next();
                orangeIterator.remove();
                if (--currentOrangeCount <= 0) continue;
                orangeIterator.add(currentOrangeCount);
            }
        }
        return orangeCounts;
    }

    private boolean updateTaskLocationPrediction(Beacon beacon, LootrunBeaconMarkerKind lootrunMarker, int distance) {
        Object t = beacon.beaconKind();
        if (!(t instanceof LootrunBeaconKind)) {
            return false;
        }
        LootrunBeaconKind color = (LootrunBeaconKind)t;
        boolean foundTask = false;
        Set currentTaskLocations = this.possibleTaskLocations.stream().filter(possibleTask -> possibleTask.taskType() == lootrunMarker.getTaskType() || possibleTask.taskType() == LootrunTaskType.UNKNOWN).collect(Collectors.toSet());
        this.taskLocations.values().forEach(hashSet -> currentTaskLocations.addAll(hashSet.stream().filter(task -> task.taskType() == lootrunMarker.getTaskType()).collect(Collectors.toSet())));
        if (currentTaskLocations.isEmpty()) {
            WynntilsMod.warn("No task locations found!");
            return false;
        }
        List<TaskPrediction> usedTaskLocations = this.beacons.entrySet().stream().filter(entry -> entry.getKey() != beacon.beaconKind()).map(Map.Entry::getValue).toList();
        TreeMap<Double, TaskLocation> predictionScores = new TreeMap<Double, TaskLocation>();
        for (TaskLocation taskLocation : currentTaskLocations) {
            Pair<Double, TaskLocation> prediction = this.calculatePredictionScore(beacon, taskLocation, distance);
            if (prediction == null) continue;
            predictionScores.put(prediction.a(), prediction.b());
        }
        for (Map.Entry entry2 : predictionScores.entrySet()) {
            TaskLocation closestTaskLocation = (TaskLocation)entry2.getValue();
            Double predictionValue = (Double)entry2.getKey();
            TaskPrediction oldPrediction = this.beacons.get(color);
            TaskPrediction newTaskPrediction = new TaskPrediction(beacon, lootrunMarker, distance, closestTaskLocation, predictionValue);
            if (oldPrediction != null && Objects.equals(oldPrediction.taskLocation(), newTaskPrediction.taskLocation())) {
                if (newTaskPrediction.predictionScore() < oldPrediction.predictionScore()) {
                    this.beacons.put(color, newTaskPrediction);
                }
                return true;
            }
            Optional<TaskPrediction> usedTaskPredictionOpt = usedTaskLocations.stream().filter(pair -> Objects.equals(pair.taskLocation(), closestTaskLocation)).findFirst();
            if (usedTaskPredictionOpt.isPresent()) {
                TaskPrediction usedTaskPrediction = usedTaskPredictionOpt.get();
                if (!(newTaskPrediction.predictionScore() < usedTaskPrediction.predictionScore())) continue;
                foundTask = true;
                this.beacons.put(color, newTaskPrediction);
                this.beacons.remove(usedTaskPrediction.beacon().beaconKind());
                this.updateTaskLocationPrediction(usedTaskPrediction.beacon(), usedTaskPrediction.lootrunMarker(), usedTaskPrediction.distance());
                break;
            }
            this.beacons.put(color, newTaskPrediction);
            foundTask = true;
            break;
        }
        LOOTRUN_BEACON_COMPASS_PROVIDER.reloadTaskMarkers();
        return foundTask;
    }

    private Pair<Double, TaskLocation> calculatePredictionScore(Beacon beacon, TaskLocation currentTaskLocation, int markerDistance) {
        Vector2d playerPosition = new Vector2d(McUtils.player().position().x(), McUtils.player().position().z());
        Vector2d taskLocationPosition = new Vector2d((double)currentTaskLocation.location().x(), (double)currentTaskLocation.location().z());
        Vector2d beaconPosition = new Vector2d(beacon.position().x(), beacon.position().z());
        if (Math.abs(beaconPosition.x() % 1.0) == 0.5 && Math.abs(beaconPosition.y() % 1.0) == 0.5 && taskLocationPosition.distance((Vector2dc)beaconPosition) < 3.0) {
            return Pair.of(0.0, currentTaskLocation);
        }
        double taskLocationDistanceToPlayer = taskLocationPosition.distance((Vector2dc)playerPosition);
        double playerDistanceToBeacon = playerPosition.distance((Vector2dc)beaconPosition);
        double beaconPositionToTask = beaconPosition.distance((Vector2dc)taskLocationPosition);
        if (taskLocationDistanceToPlayer < playerDistanceToBeacon || taskLocationDistanceToPlayer < beaconPositionToTask) {
            return null;
        }
        Vector3d playerPosition3d = new Vector3d(McUtils.player().position().x(), McUtils.player().position().y(), McUtils.player().position().z());
        Vector3d taskLocationPosition3d = new Vector3d((double)currentTaskLocation.location().x(), (double)currentTaskLocation.location().y(), (double)currentTaskLocation.location().z());
        double taskLocationDistanceToPlayer3d = taskLocationPosition3d.distance((Vector3dc)playerPosition3d);
        double distanceDiff = Math.abs(taskLocationDistanceToPlayer3d - (double)markerDistance);
        if (distanceDiff > 15.0) {
            return null;
        }
        double s = (taskLocationDistanceToPlayer + playerDistanceToBeacon + beaconPositionToTask) / 2.0;
        double area = Math.sqrt(s * (s - taskLocationDistanceToPlayer) * (s - playerDistanceToBeacon) * (s - beaconPositionToTask));
        double predictionScore = 2.0 * area / taskLocationDistanceToPlayer;
        return Pair.of(predictionScore, currentTaskLocation);
    }

    private void parseCompletedMessages(StyledText styledText) {
        Matcher matcher = styledText.getMatcher(REWARD_PULLS_PATTERN);
        if (matcher.find()) {
            int pulls = Integer.parseInt(matcher.group(1));
            this.lootrunCompletedBuilder.setRewardPulls(pulls);
            this.expectedPulls.store(pulls);
            matcher = styledText.getMatcher(TIME_ELAPSED_PATTERN);
            if (matcher.find()) {
                this.lootrunCompletedBuilder.setTimeElapsed(Integer.parseInt(matcher.group(1)) * 60 + Integer.parseInt(matcher.group(2)));
                return;
            }
            WynntilsMod.warn("Found lootrun pulls but no time elapsed: " + String.valueOf(styledText));
        }
        if ((matcher = styledText.getMatcher(REWARD_REROLLS_PATTERN)).find()) {
            this.lootrunCompletedBuilder.setRewardRerolls(Integer.parseInt(matcher.group(1)));
            matcher = styledText.getMatcher(MOBS_KILLED_PATTERN);
            if (matcher.find()) {
                this.lootrunCompletedBuilder.setMobsKilled(Integer.parseInt(matcher.group(1)));
                return;
            }
            WynntilsMod.warn("Found lootrun rerolls but no mobs killed: " + String.valueOf(styledText));
        }
        if ((matcher = styledText.getMatcher(REWARD_SACRIFICES_PATTERN)).find()) {
            this.lootrunCompletedBuilder.setRewardSacrifices(Integer.parseInt(matcher.group(1)));
            matcher = styledText.getMatcher(CHESTS_OPENED_PATTERN);
            if (matcher.find()) {
                this.lootrunCompletedBuilder.setChestsOpened(Integer.parseInt(matcher.group(1)));
                return;
            }
            WynntilsMod.warn("Found lootrun sacrifices but no chests opened: " + String.valueOf(styledText));
        }
        if ((matcher = styledText.getMatcher(LOOTRUN_EXPERIENCE_PATTERN)).find()) {
            this.lootrunCompletedBuilder.setExperienceGained(Integer.parseInt(matcher.group(1)));
            matcher = styledText.getMatcher(CHALLENGES_COMPLETED_PATTERN);
            if (matcher.find()) {
                this.lootrunCompletedBuilder.setChallengesCompleted(Integer.parseInt(matcher.group(1)));
                WynntilsMod.postEvent(this.lootrunCompletedBuilder.build());
                this.lootrunCompletedBuilder = null;
                return;
            }
            WynntilsMod.warn("Found lootrun experience but no challenges completed: " + String.valueOf(styledText));
        }
    }

    private void parseFailedMessages(StyledText styledText) {
        Matcher matcher = styledText.getMatcher(TIME_ELAPSED_PATTERN);
        if (matcher.find()) {
            this.lootrunFailedBuilder.setTimeElapsed(Integer.parseInt(matcher.group(1)) * 60 + Integer.parseInt(matcher.group(2)));
            return;
        }
        matcher = styledText.getMatcher(CHALLENGES_COMPLETED_PATTERN);
        if (matcher.find()) {
            this.lootrunFailedBuilder.setChallengesCompleted(Integer.parseInt(matcher.group(1)));
            WynntilsMod.postEvent(this.lootrunFailedBuilder.build());
            this.lootrunFailedBuilder = null;
            return;
        }
    }

    private LootrunDetails getCurrentLootrunDetails() {
        return ((Map)this.lootrunDetailsStorage.get()).getOrDefault(Models.Character.getId(), new LootrunDetails());
    }
}

