/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.lootrun.event;

import net.neoforged.bus.api.Event;

public abstract class LootrunFinishedEvent
extends Event {
    private final int challengesCompleted;
    private final int timeElapsed;

    protected LootrunFinishedEvent(int challengesCompleted, int timeElapsed) {
        this.challengesCompleted = challengesCompleted;
        this.timeElapsed = timeElapsed;
    }

    public int getChallengesCompleted() {
        return this.challengesCompleted;
    }

    public int getTimeElapsed() {
        return this.timeElapsed;
    }

    public static class Failed
    extends LootrunFinishedEvent {
        public Failed(int challengesCompleted, int timeElapsed) {
            super(challengesCompleted, timeElapsed);
        }
    }

    public static class Completed
    extends LootrunFinishedEvent {
        protected final int rewardPulls;
        protected final int rewardRerolls;
        protected final int rewardSacrifices;
        private final int experienceGained;
        private final int mobsKilled;
        private final int chestsOpened;

        public Completed(int challengesCompleted, int timeElapsed, int rewardPulls, int rewardRerolls, int rewardSacrifices, int experienceGained, int mobsKilled, int chestsOpened) {
            super(challengesCompleted, timeElapsed);
            this.rewardPulls = rewardPulls;
            this.rewardRerolls = rewardRerolls;
            this.rewardSacrifices = rewardSacrifices;
            this.experienceGained = experienceGained;
            this.mobsKilled = mobsKilled;
            this.chestsOpened = chestsOpened;
        }

        public int getRewardPulls() {
            return this.rewardPulls;
        }

        public int getRewardRerolls() {
            return this.rewardRerolls;
        }

        public int getRewardSacrifices() {
            return this.rewardSacrifices;
        }

        public int getExperienceGained() {
            return this.experienceGained;
        }

        public int getMobsKilled() {
            return this.mobsKilled;
        }

        public int getChestsOpened() {
            return this.chestsOpened;
        }
    }
}

