/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.raid.type;

public class RaidRoomInfo {
    private final String roomName;
    private final long roomStartTime;
    private long roomDamage = 0L;
    private long roomEndTime = -1L;
    private long roomTotalTime = -1L;

    public RaidRoomInfo(String roomName) {
        this.roomName = roomName;
        this.roomStartTime = System.currentTimeMillis();
    }

    public String getRoomName() {
        return this.roomName;
    }

    public long getRoomStartTime() {
        return this.roomStartTime;
    }

    public long getRoomEndTime() {
        return this.roomEndTime;
    }

    public void setRoomEndTime(long roomEndTime) {
        this.roomEndTime = roomEndTime;
        this.setRoomTotalTime();
    }

    public long getRoomTotalTime() {
        if (this.roomTotalTime != -1L) {
            return this.roomTotalTime;
        }
        return System.currentTimeMillis() - this.roomStartTime;
    }

    public void addDamage(long newDamage) {
        this.roomDamage += newDamage;
    }

    public long getRoomDamage() {
        return this.roomDamage;
    }

    private void setRoomTotalTime() {
        this.roomTotalTime = this.roomEndTime - this.roomStartTime;
    }
}

