/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.spells;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Model;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.actionbar.event.ActionBarRenderEvent;
import com.wynntils.handlers.actionbar.event.ActionBarUpdatedEvent;
import com.wynntils.handlers.item.event.ItemRenamedEvent;
import com.wynntils.mc.event.ChangeCarriedItemEvent;
import com.wynntils.mc.event.TickEvent;
import com.wynntils.models.spells.actionbar.matchers.SpellSegmentMatcher;
import com.wynntils.models.spells.actionbar.segments.SpellSegment;
import com.wynntils.models.spells.event.SpellEvent;
import com.wynntils.models.spells.type.SpellDirection;
import com.wynntils.models.spells.type.SpellFailureReason;
import com.wynntils.models.spells.type.SpellType;
import com.wynntils.models.worlds.event.WorldStateEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.neoforged.bus.api.SubscribeEvent;

public final class SpellModel
extends Model {
    private static final Pattern SPELL_CAST = Pattern.compile("^\u00a77(.*) spell cast! \u00a73\\[\u00a7b-([0-9]+) \u273a\u00a73\\](?: \u00a74\\[\u00a7c-([0-9]+) \u2764\u00a74\\])?$");
    public static final int SPELL_COST_RESET_TICKS = 60;
    private static final Queue<SpellDirection> SPELL_PACKET_QUEUE = new LinkedList<SpellDirection>();
    private boolean hideSpellInputs = false;
    private SpellDirection[] lastSpell = SpellDirection.NO_SPELL;
    private String lastBurstSpellName = "";
    private String lastSpellName = "";
    private int repeatedBurstSpellCount = 0;
    private int repeatedSpellCount = 0;
    private int ticksSinceCastBurst = 0;
    private int ticksSinceCast = 0;
    private boolean expireNextClear = false;

    public SpellModel() {
        super(List.of());
        Handlers.ActionBar.registerSegment(new SpellSegmentMatcher());
        Handlers.Item.registerKnownMarkerNames(this.getKnownMarkerNames());
    }

    private List<Pattern> getKnownMarkerNames() {
        ArrayList<Pattern> knownMarkerNames = new ArrayList<Pattern>();
        knownMarkerNames.add(SPELL_CAST);
        knownMarkerNames.addAll(Arrays.stream(SpellFailureReason.values()).map(s -> Pattern.compile(s.getMessage().getString())).toList());
        return knownMarkerNames;
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onItemRenamed(ItemRenamedEvent event) {
        StyledText msg = event.getNewName();
        SpellFailureReason failureReason = SpellFailureReason.fromMsg(msg);
        if (failureReason != null) {
            WynntilsMod.postEvent(new SpellEvent.Failed(failureReason));
            return;
        }
        Matcher spellMatcher = msg.getMatcher(SPELL_CAST);
        if (spellMatcher.matches()) {
            SpellType spellType = SpellType.fromName(spellMatcher.group(1));
            int manaCost = Integer.parseInt(spellMatcher.group(2));
            int healthCost = Integer.parseInt(Optional.ofNullable(spellMatcher.group(3)).orElse("0"));
            WynntilsMod.postEvent(new SpellEvent.Cast(spellType, manaCost, healthCost));
        }
    }

    @SubscribeEvent
    public void onActionBarUpdate(ActionBarUpdatedEvent event) {
        event.runIfPresentOrElse(SpellSegment.class, this::updateFromSpellSegment, this::handleExpiredSpell);
    }

    @SubscribeEvent
    public void onActionBarRender(ActionBarRenderEvent event) {
        if (this.hideSpellInputs) {
            event.setSegmentEnabled(SpellSegment.class, false);
        }
    }

    @SubscribeEvent
    public void onSpellCast(SpellEvent.Cast e) {
        this.ticksSinceCastBurst = 0;
        this.ticksSinceCast = 0;
        this.repeatedBurstSpellCount = e.getSpellType().getName().equals(this.lastBurstSpellName) ? ++this.repeatedBurstSpellCount : 1;
        this.repeatedSpellCount = e.getSpellType().getName().equals(this.lastSpellName) ? ++this.repeatedSpellCount : 1;
        this.lastBurstSpellName = e.getSpellType().getName();
        this.lastSpellName = e.getSpellType().getName();
    }

    @SubscribeEvent
    public void onTick(TickEvent e) {
        if (!this.lastBurstSpellName.isEmpty()) {
            ++this.ticksSinceCastBurst;
        }
        if (!this.lastSpellName.isEmpty()) {
            ++this.ticksSinceCast;
        }
        if (this.ticksSinceCastBurst >= 60) {
            this.lastBurstSpellName = "";
            this.repeatedBurstSpellCount = 0;
            this.ticksSinceCastBurst = 0;
        }
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent e) {
        SPELL_PACKET_QUEUE.clear();
        this.lastSpell = SpellDirection.NO_SPELL;
        this.lastBurstSpellName = "";
        this.lastSpellName = "";
        this.repeatedBurstSpellCount = 0;
        this.repeatedSpellCount = 0;
        this.ticksSinceCastBurst = 0;
        this.ticksSinceCast = 0;
    }

    @SubscribeEvent
    public void onHeldItemChange(ChangeCarriedItemEvent event) {
        SPELL_PACKET_QUEUE.clear();
        this.lastSpell = SpellDirection.NO_SPELL;
        this.expireNextClear = true;
    }

    public void addSpellToQueue(List<SpellDirection> spell) {
        if (!SPELL_PACKET_QUEUE.isEmpty()) {
            return;
        }
        SPELL_PACKET_QUEUE.addAll(spell);
    }

    public SpellDirection checkNextSpellDirection() {
        return SPELL_PACKET_QUEUE.peek();
    }

    public void sendNextSpell() {
        if (SPELL_PACKET_QUEUE.isEmpty()) {
            return;
        }
        SpellDirection spellDirection = SPELL_PACKET_QUEUE.poll();
        spellDirection.getSendPacketRunnable().run();
    }

    public void setHideSpellInputs(boolean hideSpellInputs) {
        this.hideSpellInputs = hideSpellInputs;
    }

    public boolean isSpellQueueEmpty() {
        return SPELL_PACKET_QUEUE.isEmpty();
    }

    public String getLastBurstSpellName() {
        return this.lastBurstSpellName;
    }

    public String getLastSpellName() {
        return this.lastSpellName;
    }

    public SpellDirection[] getLastSpell() {
        return (SpellDirection[])this.lastSpell.clone();
    }

    public int getRepeatedBurstSpellCount() {
        return this.repeatedBurstSpellCount;
    }

    public int getRepeatedSpellCount() {
        return this.repeatedSpellCount;
    }

    public int getTicksSinceCastBurst() {
        return this.ticksSinceCastBurst;
    }

    public int getTicksSinceCast() {
        return this.ticksSinceCast;
    }

    private void updateFromSpellSegment(SpellSegment spellSegment) {
        if (Arrays.equals((Object[])spellSegment.getDirections(), (Object[])this.lastSpell)) {
            return;
        }
        this.lastSpell = spellSegment.getDirections();
        WynntilsMod.postEvent(new SpellEvent.Partial(this.lastSpell));
        if (this.lastSpell.length == 3) {
            WynntilsMod.postEvent(new SpellEvent.Completed(this.lastSpell, SpellType.fromSpellDirectionArray(this.lastSpell)));
        }
    }

    private void handleExpiredSpell() {
        if (this.lastSpell.length != 0) {
            if (this.lastSpell.length != 3) {
                this.lastSpell = SpellDirection.NO_SPELL;
            }
            WynntilsMod.postEvent(new SpellEvent.Expired());
        } else if (this.expireNextClear) {
            this.expireNextClear = false;
            WynntilsMod.postEvent(new SpellEvent.Expired());
        }
    }
}

