/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.territories.type;

import net.minecraft.ChatFormatting;

public enum GuildResourceValues {
    NONE("None", ChatFormatting.WHITE, 0),
    VERY_LOW("Very Low", ChatFormatting.DARK_GREEN, 1),
    LOW("Low", ChatFormatting.GREEN, 2),
    MEDIUM("Medium", ChatFormatting.YELLOW, 3),
    HIGH("High", ChatFormatting.RED, 4),
    VERY_HIGH("Very High", ChatFormatting.DARK_RED, ChatFormatting.AQUA, 5);

    private final String asString;
    private final ChatFormatting defenceColor;
    private final ChatFormatting treasuryColor;
    private final int level;

    private GuildResourceValues(String asString, ChatFormatting color, int level) {
        this.asString = asString;
        this.defenceColor = color;
        this.treasuryColor = color;
        this.level = level;
    }

    private GuildResourceValues(String asString, ChatFormatting defenceColor, ChatFormatting treasuryColor, int level) {
        this.asString = asString;
        this.defenceColor = defenceColor;
        this.treasuryColor = treasuryColor;
        this.level = level;
    }

    public static GuildResourceValues fromString(String string) {
        for (GuildResourceValues value : GuildResourceValues.values()) {
            if (!value.asString.equals(string)) continue;
            return value;
        }
        return null;
    }

    public String getAsString() {
        return this.asString;
    }

    public ChatFormatting getDefenceColor() {
        return this.defenceColor;
    }

    public ChatFormatting getTreasuryColor() {
        return this.treasuryColor;
    }

    public GuildResourceValues getFilterNext(boolean limited) {
        if (limited) {
            return this.ordinal() - 1 == 3 ? GuildResourceValues.normalValues()[1] : GuildResourceValues.normalValues()[(this.ordinal() - 1 + 1) % GuildResourceValues.normalValues().length];
        }
        return GuildResourceValues.normalValues()[(this.ordinal() - 1 + 1) % GuildResourceValues.normalValues().length];
    }

    public GuildResourceValues getFilterPrevious(boolean limited) {
        if (limited) {
            return this.ordinal() - 1 == 1 ? GuildResourceValues.normalValues()[3] : GuildResourceValues.normalValues()[(this.ordinal() - 1 + GuildResourceValues.normalValues().length - 1) % GuildResourceValues.normalValues().length];
        }
        return GuildResourceValues.normalValues()[(this.ordinal() - 1 + GuildResourceValues.normalValues().length - 1) % GuildResourceValues.normalValues().length];
    }

    public int getLevel() {
        return this.level;
    }

    public static GuildResourceValues[] normalValues() {
        return new GuildResourceValues[]{VERY_LOW, LOW, MEDIUM, HIGH, VERY_HIGH};
    }
}

