/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.worlds;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.core.mod.event.WynncraftConnectionEvent;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.actionbar.event.ActionBarUpdatedEvent;
import com.wynntils.mc.event.ContainerSetContentEvent;
import com.wynntils.mc.event.PlayerInfoEvent;
import com.wynntils.models.character.actionbar.segments.CharacterCreationSegment;
import com.wynntils.models.character.actionbar.segments.CharacterSelectionSegment;
import com.wynntils.models.worlds.actionbar.matchers.CharacterWardrobeSegmentMatcher;
import com.wynntils.models.worlds.actionbar.matchers.WynncraftVersionSegmentMatcher;
import com.wynntils.models.worlds.actionbar.segments.CharacterWardrobeSegment;
import com.wynntils.models.worlds.actionbar.segments.WynncraftVersionSegment;
import com.wynntils.models.worlds.bossbars.SkipCutsceneBar;
import com.wynntils.models.worlds.bossbars.StreamerModeBar;
import com.wynntils.models.worlds.event.CutsceneStartedEvent;
import com.wynntils.models.worlds.event.StreamModeEvent;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.models.worlds.type.CutsceneState;
import com.wynntils.models.worlds.type.ServerRegion;
import com.wynntils.models.worlds.type.WorldState;
import com.wynntils.models.worlds.type.WynncraftVersion;
import com.wynntils.utils.mc.McUtils;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.bus.api.SubscribeEvent;

public final class WorldStateModel
extends Model {
    private static final UUID WORLD_NAME_UUID = UUID.fromString("16ff7452-714f-2752-b3cd-c3cb2068f6af");
    private static final Pattern WORLD_NAME = Pattern.compile("^\u00a7f {2}\u00a7lGlobal \\[(.*)\\]$");
    private static final Pattern HOUSING_NAME = Pattern.compile("^\u00a7f  \u00a7l([^\u00a7\"\\\\]{1,35})$");
    private static final Pattern HUB_NAME = Pattern.compile("^\n\u00a76\u00a7l play.wynncraft.com \n$");
    private static final Pattern QUICK_CONNECT_PATTERN = Pattern.compile("\u00a7aQuick Connect");
    private static final String WYNNCRAFT_BETA_NAME = "beta";
    private static final String UNKNOWN_WORLD = "WC??";
    private static final SkipCutsceneBar skipCutsceneBar = new SkipCutsceneBar();
    private CutsceneState cutsceneState = CutsceneState.NOT_IN_CUTSCENE;
    private static final StreamerModeBar streamerModeBar = new StreamerModeBar();
    private String currentWorldName = "";
    private ServerRegion currentRegion = ServerRegion.WC;
    private long serverJoinTimestamp = 0L;
    private boolean onBetaServer;
    private boolean hasJoinedAnyWorld = false;
    private boolean inStream = false;
    private boolean inCharacterWardrobe = false;
    private WynncraftVersion worldVersion = null;
    private WorldState currentState = WorldState.NOT_CONNECTED;

    public WorldStateModel() {
        super(List.of());
        Handlers.ActionBar.registerSegment(new WynncraftVersionSegmentMatcher());
        Handlers.ActionBar.registerSegment(new CharacterWardrobeSegmentMatcher());
        Handlers.BossBar.registerBar(skipCutsceneBar);
        Handlers.BossBar.registerBar(streamerModeBar);
    }

    public boolean onWorld() {
        return this.currentState == WorldState.WORLD;
    }

    public boolean inCharacterWardrobe() {
        return this.inCharacterWardrobe;
    }

    public boolean isInStream() {
        return this.inStream;
    }

    public boolean isOnBetaServer() {
        return this.onBetaServer;
    }

    public WynncraftVersion getWorldVersion() {
        return this.worldVersion;
    }

    public WorldState getCurrentState() {
        return this.currentState;
    }

    private void setState(WorldState newState, String newWorldName, boolean isFirstJoinWorld) {
        if (newState == this.currentState && newWorldName.equals(this.currentWorldName)) {
            return;
        }
        WynntilsMod.info("Changing world state to " + String.valueOf((Object)newState));
        this.cutsceneEnded();
        WorldState oldState = this.currentState;
        this.currentState = newState;
        this.currentWorldName = newWorldName;
        if (newState == WorldState.WORLD) {
            this.serverJoinTimestamp = System.currentTimeMillis();
        }
        if (this.currentWorldName.length() >= 2) {
            String region = this.currentWorldName.substring(0, 2);
            this.currentRegion = ServerRegion.fromString(region);
        }
        WynntilsMod.postEvent(new WorldStateEvent(newState, oldState, newWorldName, isFirstJoinWorld));
    }

    private void setState(WorldState newState) {
        this.setState(newState, "", false);
    }

    @SubscribeEvent
    public void disconnected(WynncraftConnectionEvent.Disconnected e) {
        this.setState(WorldState.NOT_CONNECTED);
    }

    @SubscribeEvent
    public void connectionAborted(WynncraftConnectionEvent.ConnectingAborted e) {
        this.setState(WorldState.NOT_CONNECTED);
    }

    @SubscribeEvent
    public void connecting(WynncraftConnectionEvent.Connecting e) {
        if (this.currentState != WorldState.NOT_CONNECTED) {
            WynntilsMod.error("Got connected event while already connected to server: " + e.getHost());
            this.currentState = WorldState.NOT_CONNECTED;
            this.currentWorldName = "";
        }
        String host = e.getHost();
        this.onBetaServer = host.equals(WYNNCRAFT_BETA_NAME);
        this.setState(WorldState.CONNECTING);
    }

    @SubscribeEvent
    public void connected(WynncraftConnectionEvent.Connected e) {
        if (this.currentState != WorldState.CONNECTING) {
            WynntilsMod.error("Got connected event without getting connecting event to server: " + e.getHost());
            this.currentState = WorldState.CONNECTING;
            this.currentWorldName = "";
        }
        this.setState(WorldState.INTERIM);
    }

    @SubscribeEvent
    public void remove(PlayerInfoEvent.PlayerLogOutEvent e) {
        if (e.getId().equals(WORLD_NAME_UUID) && !this.currentWorldName.isEmpty()) {
            this.setState(WorldState.INTERIM);
        }
    }

    @SubscribeEvent
    public void onActionBarUpdate(ActionBarUpdatedEvent event) {
        event.runIfPresent(CharacterCreationSegment.class, this::onCharacterCreation);
        event.runIfPresent(CharacterSelectionSegment.class, this::onCharacterSelection);
        event.runIfPresent(WynncraftVersionSegment.class, this::setWorldVersion);
        this.inCharacterWardrobe = false;
        event.runIfPresent(CharacterWardrobeSegment.class, this::onCharacterWardrobe);
    }

    @SubscribeEvent
    public void onContainerSetEvent(ContainerSetContentEvent.Post e) {
        StyledText name;
        if (e.getContainerId() != McUtils.inventoryMenu().containerId) {
            return;
        }
        ItemStack firstHotbarSlot = e.getItems().get(36);
        if (firstHotbarSlot.getItem().equals(Items.COMPASS) && (name = StyledText.fromComponent(firstHotbarSlot.getHoverName())).matches(QUICK_CONNECT_PATTERN)) {
            this.setState(WorldState.HUB);
            return;
        }
        if (this.currentState == WorldState.HUB) {
            this.setState(WorldState.INTERIM);
        }
    }

    private void onCharacterCreation(CharacterCreationSegment segment) {
        this.setState(WorldState.CHARACTER_SELECTION);
    }

    private void onCharacterSelection(CharacterSelectionSegment segment) {
        this.setState(WorldState.CHARACTER_SELECTION);
    }

    private void setWorldVersion(WynncraftVersionSegment segment) {
        this.worldVersion = segment.getWynncraftVersion();
    }

    private void onCharacterWardrobe(CharacterWardrobeSegment segment) {
        this.inCharacterWardrobe = true;
    }

    @SubscribeEvent
    public void update(PlayerInfoEvent.PlayerDisplayNameChangeEvent e) {
        if (!e.getId().equals(WORLD_NAME_UUID)) {
            return;
        }
        if (this.inStream) {
            return;
        }
        Component displayName = e.getDisplayName();
        StyledText name = StyledText.fromComponent(displayName);
        Matcher m = name.getMatcher(WORLD_NAME);
        if (this.setWorldIfMatched(m, false)) {
            return;
        }
        Matcher housingNameMatcher = name.getMatcher(HOUSING_NAME);
        this.setWorldIfMatched(housingNameMatcher, true);
    }

    private boolean setWorldIfMatched(Matcher m, boolean housing) {
        if (m.find()) {
            String worldName;
            String string = worldName = housing ? this.currentWorldName : m.group(1);
            if (worldName.isEmpty() && housing) {
                worldName = UNKNOWN_WORLD;
                WynntilsMod.warn("Changed world via housing join, current world name is unknown");
            }
            this.setState(WorldState.WORLD, worldName, !this.hasJoinedAnyWorld);
            this.hasJoinedAnyWorld = true;
            Models.Housing.updateHousingState(housing, housing ? m.group(1) : "");
            return true;
        }
        return false;
    }

    public void setStreamerMode(boolean inStream) {
        this.inStream = inStream;
        WynntilsMod.postEvent(new StreamModeEvent(inStream));
    }

    public void cutsceneStarted(boolean groupCutscene) {
        if (this.cutsceneState == CutsceneState.NOT_IN_CUTSCENE) {
            this.cutsceneState = CutsceneState.IN_CUTSCENE;
            CutsceneStartedEvent event = new CutsceneStartedEvent(groupCutscene);
            WynntilsMod.postEvent(event);
            if (event.isCanceled()) {
                this.cutsceneState = CutsceneState.SKIPPED_CUTSCENE;
            }
        }
    }

    public void cutsceneEnded() {
        this.cutsceneState = CutsceneState.NOT_IN_CUTSCENE;
    }

    public String getCurrentWorldName() {
        return this.currentWorldName;
    }

    public ServerRegion getCurrentServerRegion() {
        return this.currentRegion;
    }

    public long getServerJoinTimestamp() {
        return this.serverJoinTimestamp;
    }
}

