/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.wynnalphabet;

import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.PartStyle;
import com.wynntils.core.text.StyledText;
import com.wynntils.core.text.StyledTextPart;
import com.wynntils.core.text.type.StyleType;
import com.wynntils.models.wynnalphabet.WynnAlphabet;
import com.wynntils.models.wynnalphabet.type.TranscribeCondition;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.mc.McUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public final class WynnAlphabetModel
extends Model {
    private static final int FIFTY_INDEX = 10;
    private static final int MAX_TRANSCRIBABLE_NUMBER = 5000;
    private static final int ONE_HUNDRED_INDEX = 11;
    private static final int TEN_INDEX = 9;
    private static final List<Character> englishCharacters = List.of(Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z'), Character.valueOf('.'), Character.valueOf('!'), Character.valueOf('?'));
    private static final List<Integer> englishNumbers = List.of(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 50, 100);
    private static final List<Character> gavellianCharacters = List.of(Character.valueOf('\u24d0'), Character.valueOf('\u24d1'), Character.valueOf('\u24d2'), Character.valueOf('\u24d3'), Character.valueOf('\u24d4'), Character.valueOf('\u24d5'), Character.valueOf('\u24d6'), Character.valueOf('\u24d7'), Character.valueOf('\u24d8'), Character.valueOf('\u24d9'), Character.valueOf('\u24da'), Character.valueOf('\u24db'), Character.valueOf('\u24dc'), Character.valueOf('\u24dd'), Character.valueOf('\u24de'), Character.valueOf('\u24df'), Character.valueOf('\u24e0'), Character.valueOf('\u24e1'), Character.valueOf('\u24e2'), Character.valueOf('\u24e3'), Character.valueOf('\u24e4'), Character.valueOf('\u24e5'), Character.valueOf('\u24e6'), Character.valueOf('\u24e7'), Character.valueOf('\u24e8'), Character.valueOf('\u24e9'));
    private static final List<Character> wynnicCharacters = List.of(Character.valueOf('\u249c'), Character.valueOf('\u249d'), Character.valueOf('\u249e'), Character.valueOf('\u249f'), Character.valueOf('\u24a0'), Character.valueOf('\u24a1'), Character.valueOf('\u24a2'), Character.valueOf('\u24a3'), Character.valueOf('\u24a4'), Character.valueOf('\u24a5'), Character.valueOf('\u24a6'), Character.valueOf('\u24a7'), Character.valueOf('\u24a8'), Character.valueOf('\u24a9'), Character.valueOf('\u24aa'), Character.valueOf('\u24ab'), Character.valueOf('\u24ac'), Character.valueOf('\u24ad'), Character.valueOf('\u24ae'), Character.valueOf('\u24af'), Character.valueOf('\u24b0'), Character.valueOf('\u24b1'), Character.valueOf('\u24b2'), Character.valueOf('\u24b3'), Character.valueOf('\u24b4'), Character.valueOf('\u24b5'), Character.valueOf('\uff10'), Character.valueOf('\uff11'), Character.valueOf('\uff12'));
    private static final List<Character> wynnicNumbers = List.of(Character.valueOf('\u2474'), Character.valueOf('\u2475'), Character.valueOf('\u2476'), Character.valueOf('\u2477'), Character.valueOf('\u2478'), Character.valueOf('\u2479'), Character.valueOf('\u247a'), Character.valueOf('\u247b'), Character.valueOf('\u247c'), Character.valueOf('\u247d'), Character.valueOf('\u247e'), Character.valueOf('\u247f'));
    private static final Pattern WYNNIC_CHARACTER_PATTERN = Pattern.compile("[\u249c-\u24b5\uff10-\uff12]+");
    private static final Pattern WYNNIC_NUMBER_PATTERN = Pattern.compile("[\u2474-\u247f]+");
    private static final Pattern GAVELLIAN_CHARACTER_PATTERN = Pattern.compile("[\u24d0-\u24e9]+");
    private static final Map<Character, Character> englishToGavellianMap = new HashMap<Character, Character>();
    private static final Map<Character, Character> englishToWynnicMap = new HashMap<Character, Character>();
    private static final Map<Character, Character> gavellianToEnglishMap = new HashMap<Character, Character>();
    private static final Map<Character, Character> wynnicToEnglishMap = new HashMap<Character, Character>();
    private static final Pattern BRACKET_PATTERN = Pattern.compile("(\\[\\[.*\\]\\])|(<<.*>>)");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("\\d+");
    private static final StyledText GAVELLIAN_TRANSCRIBER = StyledText.fromString("\u00a7rHigh Gavellian Transcriber");
    private static final StyledText WYNNIC_TRANSCRIBER = StyledText.fromString("\u00a7fAncient Wynnic Transcriber");
    private WynnAlphabet selectedAlphabet = WynnAlphabet.DEFAULT;

    public WynnAlphabetModel() {
        super(List.of());
        this.createTranscribableMaps();
    }

    public StyledTextPart transcribeMessageFromWynnAlphabet(StyledTextPart originalPart, WynnAlphabet alphabet, boolean useColors, ChatFormatting colorToUse, boolean originalTextAsTooltip) {
        String originalString = originalPart.getString(null, StyleType.NONE);
        StringBuilder transcriptedStringBuilder = new StringBuilder(originalString.length());
        if (WYNNIC_NUMBER_PATTERN.matcher(originalString).matches()) {
            transcriptedStringBuilder.append(this.wynnicNumToInt(originalString));
        } else {
            for (char character : originalString.toCharArray()) {
                Character replacement = alphabet == WynnAlphabet.GAVELLIAN ? Models.WynnAlphabet.transcribeGavellianToEnglish(Character.valueOf(character)) : Models.WynnAlphabet.transcribeWynnicToEnglish(Character.valueOf(character));
                transcriptedStringBuilder.append(replacement);
            }
        }
        PartStyle partStyle = originalPart.getPartStyle();
        if (useColors && !originalTextAsTooltip) {
            partStyle = partStyle.withColor(colorToUse);
        }
        String transcriptedString = transcriptedStringBuilder.toString();
        MutableComponent hoverComponent = originalTextAsTooltip ? Component.literal((String)transcriptedString) : Component.translatable((String)"feature.wynntils.transcribeMessages.transcribedFrom", (Object[])new Object[]{StringUtils.capitalizeFirst(alphabet.toString().toLowerCase(Locale.ROOT)), originalString});
        partStyle = partStyle.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)hoverComponent));
        return new StyledTextPart(originalTextAsTooltip ? originalString : transcriptedString, partStyle.getStyle(), null, Style.EMPTY);
    }

    public String transcribeBracketedText(String message) {
        String transcriptedText;
        Pattern bracketPattern = Pattern.compile("\\[\\[([^\\]]*)\\]\\]|<<([^>]*)>>");
        ArrayList<String> wynnicSubstring = new ArrayList<String>();
        ArrayList<String> gavellianSubstring = new ArrayList<String>();
        Matcher matcher = bracketPattern.matcher(message);
        while (matcher.find()) {
            if (matcher.group(1) != null) {
                wynnicSubstring.add(matcher.group(1));
                continue;
            }
            if (matcher.group(2) == null) continue;
            gavellianSubstring.add(matcher.group(2));
        }
        if (wynnicSubstring.isEmpty() && gavellianSubstring.isEmpty()) {
            return message;
        }
        StringBuilder updatedMessage = new StringBuilder(message);
        for (String wynnicText : wynnicSubstring) {
            transcriptedText = Models.WynnAlphabet.transcribeMessageToWynnAlphabet(wynnicText.toLowerCase(Locale.ROOT), WynnAlphabet.WYNNIC);
            this.replaceTranscribed(updatedMessage, "[[" + wynnicText + "]]", transcriptedText);
        }
        for (String gavellianText : gavellianSubstring) {
            transcriptedText = Models.WynnAlphabet.transcribeMessageToWynnAlphabet(gavellianText.toLowerCase(Locale.ROOT), WynnAlphabet.GAVELLIAN);
            this.replaceTranscribed(updatedMessage, "<<" + gavellianText + ">>", transcriptedText);
        }
        return updatedMessage.toString();
    }

    public int calculateWynnicNum(String wynnicNums, int numToAdd) {
        int result = 0;
        for (char num : wynnicNums.toCharArray()) {
            if (num == this.getOneHundred().charValue()) {
                result += 100;
                continue;
            }
            if (num == this.getFifty().charValue()) {
                result += 50;
                continue;
            }
            if (num == this.getTen().charValue()) {
                result += 10;
                continue;
            }
            int wynnIndex = wynnicNumbers.indexOf(Character.valueOf(num));
            result += englishNumbers.get(wynnIndex).intValue();
        }
        Object resultStr = String.valueOf(result);
        resultStr = (String)resultStr + String.valueOf(numToAdd);
        return Integer.parseInt((String)resultStr);
    }

    public String transcribeMessageToWynnAlphabet(String original, WynnAlphabet alphabet) {
        String transcripted = original;
        if (alphabet == WynnAlphabet.GAVELLIAN) {
            for (char character : original.toCharArray()) {
                Character replacement = Models.WynnAlphabet.transcribeEnglishToGavellian(Character.valueOf(character));
                if (replacement.equals(Character.valueOf(character))) continue;
                transcripted = transcripted.replace(character, replacement.charValue());
            }
        } else {
            Matcher numMatcher = NUMBER_PATTERN.matcher(transcripted);
            transcripted = numMatcher.replaceAll(match -> {
                int numToTranscript = Integer.parseInt(match.group());
                if (numToTranscript > 5000) {
                    return "\u221e";
                }
                return Models.WynnAlphabet.intToWynnicNum(numToTranscript);
            });
            for (char character : original.toCharArray()) {
                Character replacement = Models.WynnAlphabet.transcribeEnglishToWynnic(Character.valueOf(character));
                if (replacement.equals(Character.valueOf(character))) continue;
                transcripted = transcripted.replace(character, replacement.charValue());
            }
        }
        return transcripted;
    }

    public int wynnicNumToInt(String wynnicNum) {
        int result = 0;
        for (char num : wynnicNum.toCharArray()) {
            int numIndex = wynnicNumbers.indexOf(Character.valueOf(num));
            result += englishNumbers.get(numIndex).intValue();
        }
        return result;
    }

    public String intToWynnicNum(int number) {
        int hundreds;
        StringBuilder wynnicNums = new StringBuilder();
        int fifties = (number -= (hundreds = number / 100) * 100) >= 50 ? 1 : 0;
        int tens = (number -= fifties * 50) / 10;
        number -= tens * 10;
        wynnicNums.append(String.valueOf(this.getOneHundred()).repeat(Math.max(0, hundreds)));
        wynnicNums.append(String.valueOf(this.getFifty()).repeat(Math.max(0, fifties)));
        wynnicNums.append(String.valueOf(this.getTen()).repeat(Math.max(0, tens)));
        if (number > 0) {
            wynnicNums.append(wynnicNumbers.get(englishNumbers.indexOf(number)));
        }
        return wynnicNums.toString();
    }

    public boolean shouldTranscribe(TranscribeCondition condition, WynnAlphabet alphabet) {
        return switch (condition) {
            case TranscribeCondition.NEVER -> false;
            case TranscribeCondition.TRANSCRIBER -> {
                if (alphabet == WynnAlphabet.WYNNIC) {
                    yield this.hasTranscriber(WynnAlphabet.WYNNIC);
                }
                yield this.hasTranscriber(WynnAlphabet.GAVELLIAN);
            }
            default -> true;
        };
    }

    public boolean hasWynnicOrGavellian(String message) {
        for (int i = message.length() - 1; i >= 0; --i) {
            char c = message.charAt(i);
            if (!gavellianCharacters.contains(Character.valueOf(c)) && !wynnicCharacters.contains(Character.valueOf(c)) && !wynnicNumbers.contains(Character.valueOf(c))) continue;
            return true;
        }
        return false;
    }

    public boolean containsBrackets(String message) {
        return BRACKET_PATTERN.matcher(message).find();
    }

    public Matcher getWynnicCharacterMatcher(String message) {
        return WYNNIC_CHARACTER_PATTERN.matcher(message);
    }

    public Matcher getWynnicNumberMatcher(String message) {
        return WYNNIC_NUMBER_PATTERN.matcher(message);
    }

    public Matcher getGavellianCharacterMatcher(String message) {
        return GAVELLIAN_CHARACTER_PATTERN.matcher(message);
    }

    private void createTranscribableMaps() {
        int i;
        for (i = 0; i < gavellianCharacters.size(); ++i) {
            gavellianToEnglishMap.put(gavellianCharacters.get(i), englishCharacters.get(i));
        }
        for (i = 0; i < wynnicCharacters.size(); ++i) {
            wynnicToEnglishMap.put(wynnicCharacters.get(i), englishCharacters.get(i));
        }
        for (i = 0; i < gavellianCharacters.size(); ++i) {
            englishToGavellianMap.put(englishCharacters.get(i), gavellianCharacters.get(i));
        }
        for (i = 0; i < wynnicCharacters.size(); ++i) {
            englishToWynnicMap.put(englishCharacters.get(i), wynnicCharacters.get(i));
        }
    }

    private void replaceTranscribed(StringBuilder stringBuilder, String original, String replacement) {
        int index = stringBuilder.indexOf(original);
        while (index != -1) {
            stringBuilder.replace(index, index + original.length(), replacement);
            index = stringBuilder.indexOf(original, index + replacement.length());
        }
    }

    private Character transcribeGavellianToEnglish(Character characterToTranscribe) {
        return gavellianToEnglishMap.getOrDefault(characterToTranscribe, characterToTranscribe);
    }

    private Character transcribeWynnicToEnglish(Character characterToTranscribe) {
        return wynnicToEnglishMap.getOrDefault(characterToTranscribe, characterToTranscribe);
    }

    private Character transcribeEnglishToGavellian(Character characterToTranscribe) {
        return englishToGavellianMap.getOrDefault(characterToTranscribe, characterToTranscribe);
    }

    private Character transcribeEnglishToWynnic(Character characterToTranscribe) {
        return englishToWynnicMap.getOrDefault(characterToTranscribe, characterToTranscribe);
    }

    private boolean hasTranscriber(WynnAlphabet transcriberToFind) {
        Inventory inventory = McUtils.inventory();
        for (int slotNum = 0; slotNum < 36; ++slotNum) {
            ItemStack itemStack = inventory.getItem(slotNum);
            if (!(transcriberToFind == WynnAlphabet.WYNNIC ? StyledText.fromComponent(itemStack.getHoverName()).equals(WYNNIC_TRANSCRIBER) : StyledText.fromComponent(itemStack.getHoverName()).equals(GAVELLIAN_TRANSCRIBER))) continue;
            return true;
        }
        return false;
    }

    public void setSelectedAlphabet(WynnAlphabet selectedAlphabet) {
        this.selectedAlphabet = selectedAlphabet;
    }

    public WynnAlphabet getSelectedAlphabet() {
        return this.selectedAlphabet;
    }

    public List<Character> getGavellianCharacters() {
        return gavellianCharacters;
    }

    public List<Character> getWynnicCharacters() {
        return wynnicCharacters;
    }

    public List<Character> getEnglishCharacters() {
        return englishCharacters;
    }

    public List<Integer> getEnglishNumbers() {
        return englishNumbers;
    }

    public List<Character> getWynnicNumbers() {
        return wynnicNumbers;
    }

    public Character getFifty() {
        return wynnicNumbers.get(10);
    }

    public Character getOneHundred() {
        return wynnicNumbers.get(11);
    }

    public Character getTen() {
        return wynnicNumbers.get(9);
    }
}

