/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.overlays;

import com.mojang.blaze3d.platform.Window;
import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.consumers.overlays.OverlaySize;
import com.wynntils.core.notifications.MessageContainer;
import com.wynntils.core.notifications.TimedMessageContainer;
import com.wynntils.core.notifications.event.NotificationEvent;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.utils.render.TextRenderSetting;
import com.wynntils.utils.render.TextRenderTask;
import com.wynntils.utils.render.buffered.BufferedFontRenderer;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.neoforged.bus.api.SubscribeEvent;

public class GameNotificationOverlay
extends Overlay {
    @Persisted
    private final Config<Float> messageTimeLimit = new Config<Float>(Float.valueOf(12.0f));
    @Persisted
    private final Config<Integer> messageLimit = new Config<Integer>(8);
    @Persisted
    private final Config<Boolean> invertGrowth = new Config<Boolean>(true);
    @Persisted
    private final Config<Integer> messageMaxLength = new Config<Integer>(0);
    @Persisted
    private final Config<TextShadow> textShadow = new Config<TextShadow>(TextShadow.OUTLINE);
    @Persisted
    private final Config<Boolean> overrideNewMessages = new Config<Boolean>(true);
    private TextRenderSetting textRenderSetting;
    private static final List<TimedMessageContainer> messageQueue = new LinkedList<TimedMessageContainer>();

    public GameNotificationOverlay() {
        super(new OverlayPosition(-20.0f, -5.0f, VerticalAlignment.TOP, HorizontalAlignment.RIGHT, OverlayPosition.AnchorSection.BOTTOM_RIGHT), new OverlaySize(250.0f, 110.0f));
        this.updateTextRenderSetting();
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent event) {
        messageQueue.clear();
    }

    @SubscribeEvent
    public void onGameNotification(NotificationEvent.Queue event) {
        messageQueue.add(new TimedMessageContainer(event.getMessageContainer(), this.getMessageDisplayLength()));
        if (((Boolean)this.overrideNewMessages.get()).booleanValue() && messageQueue.size() > (Integer)this.messageLimit.get()) {
            messageQueue.removeFirst();
        }
    }

    @SubscribeEvent
    public void onGameNotification(NotificationEvent.Edit event) {
        MessageContainer newContainer = event.getMessageContainer();
        messageQueue.stream().filter(timedMessageContainer -> timedMessageContainer.getMessageContainer().equals(newContainer)).findFirst().ifPresent(timedMessageContainer -> timedMessageContainer.resetRemainingTime(this.getMessageDisplayLength()));
    }

    @SubscribeEvent
    public void onGameNotification(NotificationEvent.Remove event) {
        messageQueue.removeIf(timedMessageContainer -> timedMessageContainer.getMessageContainer().equals(event.getMessageContainer()));
    }

    @Override
    public void render(GuiGraphics guiGraphics, MultiBufferSource bufferSource, DeltaTracker deltaTracker, Window window) {
        ArrayList<TimedMessageContainer> toRender = new ArrayList<TimedMessageContainer>();
        ListIterator<TimedMessageContainer> messages = messageQueue.listIterator(messageQueue.size());
        while (messages.hasPrevious()) {
            TimedMessageContainer message = messages.previous();
            if ((float)message.getRemainingTime() <= 0.0f) {
                messages.remove();
                continue;
            }
            TextRenderTask messageTask = message.getRenderTask();
            if ((Integer)this.messageMaxLength.get() == 0 || messageTask.getText().getString().length() < (Integer)this.messageMaxLength.get()) {
                toRender.add(message);
                continue;
            }
            TimedMessageContainer first = new TimedMessageContainer(new MessageContainer(messageTask.getText().getString().substring(0, (Integer)this.messageMaxLength.get())), message.getEndTime());
            TimedMessageContainer second = new TimedMessageContainer(new MessageContainer(messageTask.getText().getString().substring((Integer)this.messageMaxLength.get())), message.getEndTime());
            if (((Boolean)this.invertGrowth.get()).booleanValue()) {
                toRender.add(first);
                toRender.add(second);
                continue;
            }
            toRender.add(second);
            toRender.add(first);
        }
        if (toRender.isEmpty()) {
            return;
        }
        List<TimedMessageContainer> renderedValues = (Boolean)this.overrideNewMessages.get() != false ? toRender.subList(0, Math.min(toRender.size(), (Integer)this.messageLimit.get())) : toRender.subList(Math.max(toRender.size() - (Integer)this.messageLimit.get(), 0), toRender.size());
        Collections.reverse(renderedValues);
        if (((Boolean)this.invertGrowth.get()).booleanValue()) {
            while (renderedValues.size() < (Integer)this.messageLimit.get()) {
                renderedValues.addFirst(new TimedMessageContainer(new MessageContainer(""), (long)(((Float)this.messageTimeLimit.get()).floatValue() * 1000.0f)));
            }
        }
        BufferedFontRenderer.getInstance().renderTextsWithAlignment(guiGraphics.pose(), bufferSource, this.getRenderX(), this.getRenderY(), renderedValues.stream().map(messageContainer -> messageContainer.getRenderTask().setSetting(this.textRenderSetting.withCustomColor(messageContainer.getRenderTask().getSetting().customColor().withAlpha((float)messageContainer.getRemainingTime() / 1000.0f + 0.01f)))).toList(), this.getWidth(), this.getHeight(), this.getRenderHorizontalAlignment(), this.getRenderVerticalAlignment());
    }

    @Override
    public void renderPreview(GuiGraphics guiGraphics, MultiBufferSource bufferSource, DeltaTracker deltaTracker, Window window) {
        BufferedFontRenderer.getInstance().renderTextWithAlignment(guiGraphics.pose(), bufferSource, this.getRenderX(), this.getRenderY(), new TextRenderTask(StyledText.fromString("\u00a7r\u00a7a\u2192 \u00a7r\u00a72Player [\u00a7r\u00a7aWC1/Archer\u00a7r\u00a72]"), this.textRenderSetting), this.getWidth(), this.getHeight(), this.getRenderHorizontalAlignment(), this.getRenderVerticalAlignment());
    }

    @Override
    protected void onConfigUpdate(Config<?> config) {
        this.updateTextRenderSetting();
    }

    private long getMessageDisplayLength() {
        return (long)(((Float)this.messageTimeLimit.get()).floatValue() * 1000.0f);
    }

    private void updateTextRenderSetting() {
        this.textRenderSetting = TextRenderSetting.DEFAULT.withMaxWidth(this.getWidth()).withHorizontalAlignment(this.getRenderHorizontalAlignment()).withVerticalAlignment(this.getRenderVerticalAlignment()).withTextShadow((TextShadow)this.textShadow.get());
    }
}

