/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.base.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.screens.base.TextboxScreen;
import com.wynntils.screens.base.widgets.TextInputBoxWidget;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

public class MaskedTextInputWidget
extends AbstractWidget {
    private boolean masked = true;
    private final MaskedTextInputBoxWidget maskedTextInputBoxWidget;
    private final Button toggleMaskButton;

    public MaskedTextInputWidget(int x, int y, int width, int height, Consumer<String> onUpdateConsumer, TextboxScreen textboxScreen, String initialText) {
        super(x, y, width, height, (Component)Component.literal((String)"Masked Text Input"));
        this.maskedTextInputBoxWidget = new MaskedTextInputBoxWidget(x, y, width - 42, height, onUpdateConsumer, textboxScreen);
        this.maskedTextInputBoxWidget.setTextBoxInput(initialText);
        this.toggleMaskButton = new Button.Builder((Component)(this.masked ? Component.translatable((String)"screens.wynntils.widget.show") : Component.translatable((String)"screens.wynntils.widget.hide")), button -> this.toggleMask()).pos(x + width - 40, y).size(40, 20).build();
    }

    public MaskedTextInputWidget(int x, int y, int width, int height, Consumer<String> onUpdateConsumer, TextboxScreen textboxScreen) {
        this(x, y, width, height, onUpdateConsumer, textboxScreen, "");
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.maskedTextInputBoxWidget.render(guiGraphics, mouseX, mouseY, partialTick);
        this.toggleMaskButton.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.toggleMaskButton.isMouseOver(mouseX, mouseY)) {
            return this.toggleMaskButton.mouseClicked(mouseX, mouseY, button);
        }
        if (this.maskedTextInputBoxWidget.isMouseOver(mouseX, mouseY)) {
            return this.maskedTextInputBoxWidget.mouseClicked(mouseX, mouseY, button);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.maskedTextInputBoxWidget.isMouseOver(mouseX, mouseY)) {
            return this.maskedTextInputBoxWidget.mouseReleased(mouseX, mouseY, button);
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.maskedTextInputBoxWidget.isMouseOver(mouseX, mouseY)) {
            return this.maskedTextInputBoxWidget.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public void setY(int y) {
        super.setY(y);
        this.maskedTextInputBoxWidget.setY(y);
        this.toggleMaskButton.setY(y);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    private void toggleMask() {
        this.masked = !this.masked;
        this.toggleMaskButton.setMessage((Component)(this.masked ? Component.translatable((String)"screens.wynntils.widget.show") : Component.translatable((String)"screens.wynntils.widget.hide")));
    }

    private final class MaskedTextInputBoxWidget
    extends TextInputBoxWidget {
        private MaskedTextInputBoxWidget(int x, int y, int width, int height, Consumer<String> onUpdateConsumer, TextboxScreen textboxScreen) {
            super(x, y, width, height, onUpdateConsumer, textboxScreen, null);
        }

        @Override
        protected void doRenderWidget(PoseStack poseStack, String renderedText, int renderedTextStart, String firstPortion, String highlightedPortion, String lastPortion, Font font, int firstWidth, int highlightedWidth, int lastWidth) {
            super.doRenderWidget(poseStack, MaskedTextInputWidget.this.masked ? "*".repeat(renderedText.length()) : renderedText, renderedTextStart, MaskedTextInputWidget.this.masked ? "*".repeat(firstPortion.length()) : firstPortion, MaskedTextInputWidget.this.masked ? "*".repeat(highlightedPortion.length()) : highlightedPortion, MaskedTextInputWidget.this.masked ? "*".repeat(lastPortion.length()) : lastPortion, font, firstWidth, highlightedWidth, lastWidth);
        }
    }
}

