/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.base.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.screens.base.TooltipProvider;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class ReloadButton
extends WynntilsButton
implements TooltipProvider {
    private final List<Component> reloadTooltip;
    private final Runnable onClickRunnable;

    public ReloadButton(int x, int y, int width, int height, String activityType, Runnable onClickRunnable) {
        super(x, y, width, height, (Component)Component.literal((String)"Reload Button"));
        this.onClickRunnable = onClickRunnable;
        this.reloadTooltip = List.of(Component.translatable((String)"screens.wynntils.wynntilsActivities.reload.name").withStyle(ChatFormatting.WHITE), Component.translatable((String)"screens.wynntils.wynntilsActivities.reload.description", (Object[])new Object[]{activityType}).withStyle(ChatFormatting.GRAY));
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        Texture reloadButton = Texture.RELOAD_ICON_OFFSET;
        if (this.isHovered) {
            RenderUtils.drawTexturedRect(poseStack, reloadButton.resource(), this.getX(), this.getY(), 0.0f, this.width, this.height, reloadButton.width() / 2, 0, reloadButton.width() / 2, reloadButton.height(), reloadButton.width(), reloadButton.height());
        } else {
            RenderUtils.drawTexturedRect(poseStack, reloadButton.resource(), this.getX(), this.getY(), 0.0f, this.width, this.height, 0, 0, reloadButton.width() / 2, reloadButton.height(), reloadButton.width(), reloadButton.height());
        }
    }

    public void onPress() {
        this.onClickRunnable.run();
    }

    @Override
    public List<Component> getTooltipLines() {
        return this.reloadTooltip;
    }
}

