/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.container.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Models;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.container.widgets.PersonalStorageUtilitiesWidget;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class PersonalStorageEditModeButton
extends WynntilsButton {
    private static final List<Component> CONFIRM_TOOLTIP = List.of(Component.translatable((String)"screens.wynntils.containers.save.name").withStyle(ChatFormatting.GREEN), Component.translatable((String)"screens.wynntils.containers.save.description").withStyle(ChatFormatting.GRAY));
    private static final List<Component> EDIT_TOOLTIP = List.of(Component.translatable((String)"screens.wynntils.containers.edit.name").withStyle(ChatFormatting.YELLOW), Component.translatable((String)"screens.wynntils.containers.edit.description").withStyle(ChatFormatting.GRAY));
    private final PersonalStorageUtilitiesWidget parent;

    public PersonalStorageEditModeButton(int x, int y, int width, int height, PersonalStorageUtilitiesWidget parent) {
        super(x, y, width, height, (Component)Component.literal((String)"Personal Storage Edit Name Button"));
        this.parent = parent;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        RenderUtils.drawScalingTexturedRect(poseStack, Texture.EDIT_NAME_ICON.resource(), this.getX(), this.getY(), 0.0f, this.width, this.height, Texture.EDIT_NAME_ICON.width(), Texture.EDIT_NAME_ICON.height());
        if (this.isHovered) {
            List<Component> tooltipToUse = Models.Bank.isEditingMode() ? CONFIRM_TOOLTIP : EDIT_TOOLTIP;
            McUtils.screen().setTooltipForNextRenderPass(Lists.transform(tooltipToUse, Component::getVisualOrderText));
        }
    }

    public void onPress() {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (Models.Bank.isEditingMode()) {
                this.parent.saveEditModeChanges();
                this.parent.updatePageName();
                this.parent.toggleEditMode(false);
            } else {
                this.parent.toggleEditMode(true);
            }
        } else if (button == 1) {
            if (Models.Bank.isEditingMode()) {
                this.parent.toggleEditMode(false);
                this.parent.updatePageIcons();
            } else {
                Models.Bank.resetCurrentPageName();
                this.parent.updatePageName();
            }
        }
        return true;
    }
}

