/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guides.aspect;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.guides.aspect.GuideAspectItemStack;
import com.wynntils.screens.guides.aspect.WynntilsAspectGuideScreen;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class GuideAspectItemStackButton
extends WynntilsButton {
    private static final CustomColor TIER_1_HIGHLIGHT_COLOR = CustomColor.fromChatFormatting(ChatFormatting.DARK_GRAY);
    private static final CustomColor TIER_2_HIGHLIGHT_COLOR = new CustomColor(205, 127, 50);
    private static final CustomColor TIER_3_HIGHLIGHT_COLOR = new CustomColor(192, 192, 192);
    private static final CustomColor TIER_4_HIGHLIGHT_COLOR = new CustomColor(255, 215, 0);
    private final GuideAspectItemStack itemStack;
    private final CustomColor textColor;

    public GuideAspectItemStackButton(int x, int y, int width, int height, GuideAspectItemStack itemStack, WynntilsAspectGuideScreen screen) {
        super(x, y, width, height, (Component)Component.literal((String)"Guide AspectItemStack Button"));
        this.itemStack = itemStack;
        itemStack.buildTooltip();
        this.textColor = switch (itemStack.getTier()) {
            case 2 -> TIER_2_HIGHLIGHT_COLOR;
            case 3 -> TIER_3_HIGHLIGHT_COLOR;
            case 4 -> TIER_4_HIGHLIGHT_COLOR;
            default -> TIER_1_HIGHLIGHT_COLOR;
        };
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        CustomColor color = CustomColor.fromChatFormatting(this.itemStack.getAspectInfo().gearTier().getChatFormatting());
        RenderUtils.drawTexturedRectWithColor(poseStack, Texture.HIGHLIGHT.resource(), color.withAlpha(1.0f), this.getX() - 1, this.getY() - 1, 0.0f, 18.0f, 18.0f, Texture.HIGHLIGHT.width(), Texture.HIGHLIGHT.height());
        RenderUtils.renderItem(guiGraphics, this.itemStack, this.getX(), this.getY());
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 200.0f);
        FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(MathUtils.toRoman(this.itemStack.getTier())), (float)(this.getX() + 2), (float)(this.getX() + 14), (float)(this.getY() + 8), 0.0f, this.textColor, HorizontalAlignment.CENTER, TextShadow.OUTLINE);
        poseStack.popPose();
        if (Services.Favorites.isFavorite(this.itemStack)) {
            RenderUtils.drawScalingTexturedRect(poseStack, Texture.FAVORITE_ICON.resource(), this.getX() + 12, this.getY() - 4, 200.0f, 9.0f, 9.0f, Texture.FAVORITE_ICON.width(), Texture.FAVORITE_ICON.height());
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!KeyboardUtils.isKeyDown(340) && !KeyboardUtils.isKeyDown(344)) {
            return false;
        }
        String unformattedName = StyledText.fromComponent(this.itemStack.getHoverName()).getStringWithoutFormatting();
        if (button == 0) {
            Services.Favorites.toggleFavorite(unformattedName);
        }
        return true;
    }

    public void onPress() {
    }

    public GuideAspectItemStack getItemStack() {
        return this.itemStack;
    }
}

