/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guides.ingredient;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Services;
import com.wynntils.core.net.UrlId;
import com.wynntils.models.ingredients.type.IngredientTierFormatting;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.guides.ingredient.GuideIngredientItemStack;
import com.wynntils.screens.guides.ingredient.WynntilsIngredientGuideScreen;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class GuideIngredientItemStackButton
extends WynntilsButton {
    private final GuideIngredientItemStack itemStack;

    public GuideIngredientItemStackButton(int x, int y, int width, int height, GuideIngredientItemStack itemStack, WynntilsIngredientGuideScreen screen) {
        super(x, y, width, height, (Component)Component.literal((String)"Guide IngredientItemStack Button"));
        this.itemStack = itemStack;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        CustomColor color = this.getHighlightColor(this.itemStack.getIngredientInfo().tier());
        RenderUtils.drawTexturedRectWithColor(poseStack, Texture.HIGHLIGHT.resource(), color.withAlpha(1.0f), this.getX() - 1, this.getY() - 1, 0.0f, 18.0f, 18.0f, Texture.HIGHLIGHT.width(), Texture.HIGHLIGHT.height());
        RenderUtils.renderItem(guiGraphics, this.itemStack, this.getX(), this.getY());
        String unformattedName = this.itemStack.getIngredientInfo().name();
        if (Services.Favorites.isFavorite(unformattedName)) {
            RenderUtils.drawScalingTexturedRect(poseStack, Texture.FAVORITE_ICON.resource(), this.getX() + 12, this.getY() - 4, 200.0f, 9.0f, 9.0f, Texture.FAVORITE_ICON.width(), Texture.FAVORITE_ICON.height());
        }
    }

    private CustomColor getHighlightColor(int tier) {
        CustomColor highlightColor = IngredientTierFormatting.fromTierNum(tier).getHighlightColor();
        if (highlightColor == null) {
            WynntilsMod.warn("Invalid ingredient tier for: " + this.itemStack.getIngredientInfo().name() + ": " + tier);
            return CustomColor.NONE;
        }
        return highlightColor;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!KeyboardUtils.isKeyDown(340) && !KeyboardUtils.isKeyDown(344)) {
            return false;
        }
        String unformattedName = this.itemStack.getIngredientInfo().name();
        if (button == 1) {
            Managers.Net.openLink(UrlId.LINK_WYNNCRAFT_ITEM_LOOKUP, Map.of("itemname", unformattedName));
            return true;
        }
        if (button == 0) {
            Services.Favorites.toggleFavorite(unformattedName);
        }
        return true;
    }

    public void onPress() {
    }

    public GuideIngredientItemStack getItemStack() {
        return this.itemStack;
    }
}

