/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.itemfilter.widgets.numeric;

import com.wynntils.screens.base.widgets.TextInputBoxWidget;
import com.wynntils.screens.itemfilter.ItemFilterScreen;
import com.wynntils.screens.itemfilter.widgets.GeneralFilterWidget;
import com.wynntils.screens.itemfilter.widgets.ProviderFilterListWidget;
import com.wynntils.services.itemfilter.type.StatFilter;
import com.wynntils.services.itemfilter.type.StatProviderAndFilterPair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

public abstract class InequalityNumericFilterWidget<T>
extends GeneralFilterWidget {
    private final Button removeButton;
    private final Button inequalityButton;
    private final TextInputBoxWidget entryInput;
    private boolean ignoreUpdate = false;
    private InequalityType inequalityType = InequalityType.GREATER_THAN;

    protected InequalityNumericFilterWidget(int x, int y, int width, int height, ProviderFilterListWidget parent, ItemFilterScreen filterScreen) {
        super(x, y, width, height, (Component)Component.literal((String)"Inequality Numeric Filter Widget"), parent);
        this.entryInput = new TextInputBoxWidget(this.getX(), this.getY(), width - 76, this.getHeight(), s -> {
            if (this.ignoreUpdate) {
                return;
            }
            parent.updateQuery();
        }, filterScreen);
        this.inequalityButton = new Button.Builder((Component)Component.literal((String)this.inequalityType.getMessage()), null).pos(this.getX() + width - 74, this.getY()).size(20, 20).build();
        this.removeButton = new Button.Builder((Component)Component.literal((String)"\ud83d\uddd1"), button -> parent.removeWidget(this)).pos(this.getX() + width - 20, this.getY()).size(20, 20).build();
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.entryInput.render(guiGraphics, mouseX, mouseY, partialTick);
        this.inequalityButton.render(guiGraphics, mouseX, mouseY, partialTick);
        this.removeButton.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.entryInput.isMouseOver(mouseX, mouseY)) {
            return this.entryInput.mouseClicked(mouseX, mouseY, button);
        }
        if (this.removeButton.isMouseOver(mouseX, mouseY)) {
            return this.removeButton.mouseClicked(mouseX, mouseY, button);
        }
        if (this.inequalityButton.isMouseOver(mouseX, mouseY)) {
            if (button == 0) {
                this.cycleInequality(1);
                return true;
            }
            if (button == 1) {
                this.cycleInequality(-1);
                return true;
            }
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.entryInput.isMouseOver(mouseX, mouseY)) {
            return this.entryInput.mouseReleased(mouseX, mouseY, button);
        }
        if (this.inequalityButton.isMouseOver(mouseX, mouseY)) {
            return this.inequalityButton.mouseReleased(mouseX, mouseY, button);
        }
        if (this.removeButton.isMouseOver(mouseX, mouseY)) {
            return this.removeButton.mouseReleased(mouseX, mouseY, button);
        }
        return false;
    }

    @Override
    public void updateY(int y) {
        this.setY(y);
        this.entryInput.setY(y);
        this.inequalityButton.setY(y);
        this.removeButton.setY(y);
    }

    @Override
    protected StatProviderAndFilterPair getFilterPair() {
        if (this.entryInput.getTextBoxInput().isEmpty()) {
            return null;
        }
        String value = this.entryInput.getTextBoxInput();
        Optional<StatFilter<StatFilter>> singleStatFilterOpt = this.getInequalityStatFilter(value, this.inequalityType);
        return singleStatFilterOpt.map(statFilter -> new StatProviderAndFilterPair(this.parent.getProvider(), statFilter)).orElse(null);
    }

    private void cycleInequality(int direction) {
        ArrayList<InequalityType> types = new ArrayList<InequalityType>(List.of(InequalityType.values()));
        this.inequalityType = types.indexOf((Object)this.inequalityType) + direction < 0 ? (InequalityType)((Object)types.getLast()) : (types.indexOf((Object)this.inequalityType) + direction == types.size() ? (InequalityType)((Object)types.getFirst()) : (InequalityType)((Object)types.get(types.indexOf((Object)this.inequalityType) + direction)));
        this.inequalityButton.setMessage((Component)Component.literal((String)this.inequalityType.getMessage()));
        this.parent.updateQuery();
    }

    protected void setEntryInput(String input) {
        this.ignoreUpdate = true;
        this.entryInput.setTextBoxInput(input);
        this.ignoreUpdate = false;
    }

    protected void setInequalityType(InequalityType inequalityType) {
        this.inequalityType = inequalityType;
        this.inequalityButton.setMessage((Component)Component.literal((String)inequalityType.getMessage()));
    }

    protected abstract Optional<StatFilter<T>> getInequalityStatFilter(String var1, InequalityType var2);

    protected static enum InequalityType {
        GREATER_THAN(">"),
        GREATER_THAN_EQUAL(">="),
        LESS_THAN("<"),
        LESS_THAN_EQUAL("<=");

        private final String message;

        private InequalityType(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

