/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.itemfilter.widgets.numeric;

import com.wynntils.screens.base.widgets.TextInputBoxWidget;
import com.wynntils.screens.itemfilter.ItemFilterScreen;
import com.wynntils.screens.itemfilter.widgets.GeneralFilterWidget;
import com.wynntils.screens.itemfilter.widgets.ProviderFilterListWidget;
import com.wynntils.services.itemfilter.type.StatFilter;
import com.wynntils.services.itemfilter.type.StatProviderAndFilterPair;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

public abstract class SingleNumericFilterWidget<T>
extends GeneralFilterWidget {
    private final Button removeButton;
    private final TextInputBoxWidget entryInput;
    private boolean ignoreUpdate = false;

    protected SingleNumericFilterWidget(int x, int y, int width, int height, ProviderFilterListWidget parent, ItemFilterScreen filterScreen) {
        super(x, y, width, height, (Component)Component.literal((String)"Single Numeric Filter Widget"), parent);
        this.entryInput = new TextInputBoxWidget(this.getX(), this.getY(), width - 54, this.getHeight(), s -> {
            if (this.ignoreUpdate) {
                return;
            }
            parent.updateQuery();
        }, filterScreen);
        this.removeButton = new Button.Builder((Component)Component.literal((String)"\ud83d\uddd1"), button -> parent.removeWidget(this)).pos(this.getX() + width - 20, this.getY()).size(20, 20).build();
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.entryInput.render(guiGraphics, mouseX, mouseY, partialTick);
        this.removeButton.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.entryInput.isMouseOver(mouseX, mouseY)) {
            return this.entryInput.mouseClicked(mouseX, mouseY, button);
        }
        if (this.removeButton.isMouseOver(mouseX, mouseY)) {
            return this.removeButton.mouseClicked(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.entryInput.isMouseOver(mouseX, mouseY)) {
            return this.entryInput.mouseReleased(mouseX, mouseY, button);
        }
        if (this.removeButton.isMouseOver(mouseX, mouseY)) {
            return this.removeButton.mouseReleased(mouseX, mouseY, button);
        }
        return false;
    }

    @Override
    public void updateY(int y) {
        this.setY(y);
        this.entryInput.setY(y);
        this.removeButton.setY(y);
    }

    @Override
    protected StatProviderAndFilterPair getFilterPair() {
        if (this.entryInput.getTextBoxInput().isEmpty()) {
            return null;
        }
        String value = this.entryInput.getTextBoxInput();
        Optional<StatFilter<StatFilter>> singleStatFilterOpt = this.getSingleStatFilter(value);
        return singleStatFilterOpt.map(statFilter -> new StatProviderAndFilterPair(this.parent.getProvider(), statFilter)).orElse(null);
    }

    protected void setEntryInput(String input) {
        this.ignoreUpdate = true;
        this.entryInput.setTextBoxInput(input);
        this.ignoreUpdate = false;
    }

    protected abstract Optional<StatFilter<T>> getSingleStatFilter(String var1);
}

