/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.maps;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.screens.base.WynntilsGridLayoutScreen;
import com.wynntils.screens.maps.PoiManagementScreen;
import com.wynntils.screens.maps.widgets.IconFilterWidget;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public final class IconFilterScreen
extends WynntilsGridLayoutScreen {
    private static final int HEADER_HEIGHT = 13;
    private static final int ICONS_PER_ROW = 7;
    private static final int MAX_ICONS_TO_DISPLAY = 28;
    private final List<AbstractWidget> iconFilterWidgets = new ArrayList<AbstractWidget>();
    private final Map<Texture, Boolean> icons;
    private final PoiManagementScreen previousScreen;
    private Button includeAllButton;
    private Button excludeAllButton;
    private boolean draggingScroll = false;
    private float backgroundHeight;
    private float backgroundWidth;
    private float backgroundX;
    private float backgroundY;
    private float scrollButtonHeight;
    private float scrollButtonRenderX;
    private float scrollButtonRenderY;
    private int iconButtonSize;
    private int scrollAreaHeight;
    private int scrollOffset = 0;
    private List<Texture> usedIcons;

    private IconFilterScreen(PoiManagementScreen previousScreen, Map<Texture, Boolean> icons) {
        super((Component)Component.literal((String)"Icon Filter Screen"));
        this.previousScreen = previousScreen;
        this.icons = icons;
    }

    public static Screen create(PoiManagementScreen previousScreen, Map<Texture, Boolean> icons) {
        return new IconFilterScreen(previousScreen, icons);
    }

    public void onClose() {
        McUtils.setScreen(this.previousScreen);
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.iconButtonSize = (int)(this.dividedWidth * 5.0f);
        this.backgroundX = this.dividedWidth * 10.0f;
        this.backgroundWidth = this.dividedWidth * 44.0f;
        this.backgroundY = this.dividedHeight * 7.0f;
        this.backgroundHeight = this.dividedHeight * 50.0f;
        this.scrollButtonHeight = this.dividedWidth / 2.0f / (float)Texture.SCROLL_BUTTON.width() * (float)Texture.SCROLL_BUTTON.height();
        this.scrollAreaHeight = (int)(this.backgroundHeight - this.scrollButtonHeight) - (int)(this.dividedHeight * 4.0f);
        this.scrollButtonRenderX = (float)((int)(this.dividedWidth * 52.0f)) + this.dividedWidth / 4.0f;
        int filterButtonWidth = (int)(this.dividedWidth * 10.0f);
        this.includeAllButton = new Button.Builder((Component)Component.translatable((String)"screens.wynntils.iconFilter.includeAll"), button -> {
            this.icons.replaceAll((key, value) -> true);
            button.active = false;
            this.excludeAllButton.active = true;
            this.populateIcons();
        }).pos((int)this.backgroundX, (int)(this.dividedHeight * 3.0f)).size(filterButtonWidth, 20).build();
        this.includeAllButton.active = this.icons.containsValue(false);
        this.addRenderableWidget((GuiEventListener)this.includeAllButton);
        this.excludeAllButton = new Button.Builder((Component)Component.translatable((String)"screens.wynntils.iconFilter.excludeAll"), button -> {
            this.icons.replaceAll((key, value) -> false);
            button.active = false;
            this.includeAllButton.active = true;
            this.populateIcons();
        }).pos((int)this.backgroundX + filterButtonWidth + 5, (int)(this.dividedHeight * 3.0f)).size(filterButtonWidth, 20).build();
        this.excludeAllButton.active = this.icons.containsValue(true);
        this.addRenderableWidget((GuiEventListener)this.excludeAllButton);
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"screens.wynntils.iconFilter.done"), button -> McUtils.mc().setScreen((Screen)this.previousScreen)).pos((int)(this.dividedWidth * 44.0f), (int)(this.dividedHeight * 3.0f)).size(filterButtonWidth, 20).build());
        this.usedIcons = new ArrayList<Texture>(this.icons.keySet());
        this.populateIcons();
    }

    @Override
    public void doRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.doRender(guiGraphics, mouseX, mouseY, partialTick);
        this.renderScrollButton(guiGraphics.pose());
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        RenderUtils.drawScalingTexturedRect(guiGraphics.pose(), Texture.WAYPOINT_MANAGER_BACKGROUND.resource(), this.backgroundX, this.backgroundY, 0.0f, this.backgroundWidth, this.backgroundHeight, Texture.WAYPOINT_MANAGER_BACKGROUND.width(), Texture.WAYPOINT_MANAGER_BACKGROUND.height());
    }

    @Override
    public boolean doMouseClicked(double mouseX, double mouseY, int button) {
        if (!this.draggingScroll && this.usedIcons.size() > 28 && MathUtils.isInside((int)mouseX, (int)mouseY, (int)this.scrollButtonRenderX, (int)(this.scrollButtonRenderX + this.dividedWidth / 2.0f), (int)this.scrollButtonRenderY, (int)(this.scrollButtonRenderY + this.scrollButtonHeight))) {
            this.draggingScroll = true;
            return true;
        }
        return super.doMouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.draggingScroll) {
            return false;
        }
        int renderY = (int)(((float)this.height - this.backgroundHeight) / 2.0f + (float)((int)(this.dividedHeight * 3.0f)));
        int scrollAreaStartY = renderY + 7;
        int newValue = Math.round(MathUtils.map((float)mouseY, scrollAreaStartY, scrollAreaStartY + this.scrollAreaHeight, 0.0f, this.getMaxScrollOffset()));
        this.scroll(newValue - this.scrollOffset);
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.draggingScroll = false;
        return true;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        double scrollValue = -Math.signum(deltaY);
        this.scroll((int)scrollValue);
        return true;
    }

    public void toggleIcon(Texture icon) {
        this.icons.put(icon, this.icons.get((Object)icon) == false);
        this.previousScreen.setFilteredIcons(this.icons);
        this.includeAllButton.active = this.icons.containsValue(false);
        this.excludeAllButton.active = this.icons.containsValue(true);
        this.populateIcons();
    }

    private void renderScrollButton(PoseStack poseStack) {
        if (this.usedIcons.size() <= 28) {
            return;
        }
        this.scrollButtonRenderY = ((float)this.height - this.backgroundHeight) / 2.0f + (float)((int)(this.dividedHeight * 3.0f)) + MathUtils.map(this.scrollOffset, 0.0f, this.getMaxScrollOffset(), 0.0f, this.scrollAreaHeight);
        RenderUtils.drawScalingTexturedRect(poseStack, Texture.SCROLL_BUTTON.resource(), this.scrollButtonRenderX, this.scrollButtonRenderY, 1.0f, this.dividedWidth / 2.0f, this.scrollButtonHeight, Texture.SCROLL_BUTTON.width(), Texture.SCROLL_BUTTON.height());
    }

    private void scroll(int delta) {
        int maxValue = this.getMaxScrollOffset();
        this.scrollOffset = MathUtils.clamp(this.scrollOffset + delta, 0, maxValue);
        this.populateIcons();
    }

    private int getMaxScrollOffset() {
        int maxItemOffset = Math.max(0, this.usedIcons.size() - 28);
        return maxItemOffset / 7 + (maxItemOffset % 7 > 0 ? 1 : 0);
    }

    private void populateIcons() {
        int currentIcon;
        for (AbstractWidget widget : this.iconFilterWidgets) {
            this.removeWidget((GuiEventListener)widget);
        }
        this.iconFilterWidgets.clear();
        int row = (int)((float)((int)(this.dividedHeight * 13.0f)) + this.dividedHeight / 2.0f);
        int xPos = (int)(this.dividedWidth * 14.0f);
        int widgetsOnCurrentRow = 0;
        for (int i = 0; i < 28 && (currentIcon = i + this.scrollOffset * 7) <= this.usedIcons.size() - 1; ++i) {
            Texture icon = this.usedIcons.get(currentIcon);
            IconFilterWidget filterWidget = new IconFilterWidget(xPos, row, this.iconButtonSize, this.iconButtonSize, icon, this, this.icons.getOrDefault((Object)icon, false));
            this.iconFilterWidgets.add(filterWidget);
            this.addRenderableWidget((GuiEventListener)filterWidget);
            if (++widgetsOnCurrentRow == 7) {
                row += this.iconButtonSize;
                xPos = (int)(this.dividedWidth * 14.0f);
                widgetsOnCurrentRow = 0;
                continue;
            }
            xPos += this.iconButtonSize;
        }
    }
}

