/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.maps.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.screens.maps.PoiCreationScreen;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class IconButton
extends AbstractWidget {
    private final boolean selected;
    private final float iconRenderX;
    private final float iconRenderY;
    private final float iconWidth;
    private final float iconHeight;
    private final Texture mapIcon;

    public IconButton(int x, int y, int width, Texture mapIcon, boolean selected) {
        super(x, y, width, 20, (Component)Component.literal((String)"Icon Button"));
        this.mapIcon = mapIcon;
        this.selected = selected;
        float scaleFactor = 0.8f * (float)Math.min(width, this.height) / (float)Math.max(mapIcon.width(), mapIcon.height());
        this.iconWidth = (float)mapIcon.width() * scaleFactor;
        this.iconHeight = (float)mapIcon.height() * scaleFactor;
        this.iconRenderX = (float)x + (float)width / 2.0f - this.iconWidth / 2.0f;
        this.iconRenderY = (float)y + (float)this.height / 2.0f - this.iconHeight / 2.0f;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        RenderUtils.drawRect(poseStack, CommonColors.BLACK.withAlpha(this.isHovered ? 0.7f : 0.5f), this.getX(), this.getY(), 0.0f, this.width, this.height);
        RenderUtils.drawScalingTexturedRect(poseStack, this.mapIcon.resource(), this.iconRenderX, this.iconRenderY, 1.0f, this.iconWidth, this.iconHeight, this.mapIcon.width(), this.mapIcon.height());
        if (this.selected) {
            RenderUtils.drawRect(poseStack, CommonColors.LIGHT_BLUE.withAlpha(35), this.getX(), this.getY(), 1.0f, this.width, this.height);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Screen screen = McUtils.screen();
        if (screen instanceof PoiCreationScreen) {
            PoiCreationScreen poiCreationScreen = (PoiCreationScreen)screen;
            poiCreationScreen.setSelectedIcon(this.mapIcon);
        }
        return true;
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

