/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.secrets.widgets;

import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.TextboxScreen;
import com.wynntils.screens.base.widgets.MaskedTextInputWidget;
import com.wynntils.services.secrets.type.WynntilsSecret;
import com.wynntils.utils.EnumUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

public class SecretInputWidget
extends AbstractWidget {
    private final MaskedTextInputWidget maskedTextInputWidget;
    private final Button openLinkButton;
    private final WynntilsSecret wynntilsSecret;

    public SecretInputWidget(int x, int y, int width, int height, TextboxScreen textboxScreen, WynntilsSecret wynntilsSecret) {
        super(x, y, width, height, null);
        this.maskedTextInputWidget = new MaskedTextInputWidget(x + 120, y, width - 140, height, s -> Services.Secrets.setSecret(wynntilsSecret, (String)s), textboxScreen, Services.Secrets.getSecret(wynntilsSecret));
        this.openLinkButton = new Button.Builder((Component)Component.literal((String)"\ud83c\udf10"), b -> Managers.Net.openLink(wynntilsSecret.getUrl())).size(20, 20).pos(x + width - 20, y).tooltip(Tooltip.create((Component)Component.translatable((String)"screens.wynntils.secrets.openLink"))).build();
        this.wynntilsSecret = wynntilsSecret;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        FontRenderer.getInstance().renderScrollingText(guiGraphics.pose(), StyledText.fromString(EnumUtils.toNiceString(this.wynntilsSecret)), this.getX(), (float)this.getY() + (float)this.getHeight() / 2.0f, 120.0f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        this.maskedTextInputWidget.render(guiGraphics, mouseX, mouseY, partialTick);
        this.openLinkButton.render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.isHovered && !this.openLinkButton.isHovered()) {
            McUtils.screen().setTooltipForNextRenderPass((Component)Component.translatable((String)this.wynntilsSecret.getDescriptionKey()));
        }
    }

    public void setY(int y) {
        super.setY(y);
        this.maskedTextInputWidget.setY(y);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.maskedTextInputWidget.isMouseOver(mouseX, mouseY)) {
            return this.maskedTextInputWidget.mouseClicked(mouseX, mouseY, button);
        }
        if (this.openLinkButton.isMouseOver(mouseX, mouseY)) {
            return this.openLinkButton.mouseClicked(mouseX, mouseY, button);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.maskedTextInputWidget.isMouseOver(mouseX, mouseY)) {
            return this.maskedTextInputWidget.mouseReleased(mouseX, mouseY, button);
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.maskedTextInputWidget.isMouseOver(mouseX, mouseY)) {
            return this.maskedTextInputWidget.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

