/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.settings.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.features.Configurable;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.overlays.CustomNameProperty;
import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.base.widgets.WynntilsCheckbox;
import com.wynntils.screens.settings.WynntilsBookSettingsScreen;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ConfigurableButton
extends WynntilsButton {
    private final Configurable configurable;
    private final WynntilsCheckbox enabledCheckbox;
    private final int maskTopY;
    private final int maskBottomY;
    private final int matchingConfigs;
    private final List<Component> descriptionTooltip;
    private final List<Component> toggleTooltip;
    private final WynntilsBookSettingsScreen settingsScreen;

    public ConfigurableButton(int x, int y, int width, int height, Configurable configurable, WynntilsBookSettingsScreen screen, int matchingConfigs) {
        super(x, y, width, height, (Component)Component.literal((String)configurable.getTranslatedName()));
        this.configurable = configurable;
        this.settingsScreen = screen;
        if (configurable instanceof Feature) {
            Feature feature = (Feature)configurable;
            this.descriptionTooltip = ComponentUtils.wrapTooltips(List.of(Component.literal((String)feature.getTranslatedDescription())), 150);
            this.toggleTooltip = ComponentUtils.wrapTooltips(List.of(Component.translatable((String)"screens.wynntils.settingsScreen.toggleFeature", (Object[])new Object[]{configurable.getTranslatedName()})), 150);
        } else {
            this.descriptionTooltip = List.of();
            this.toggleTooltip = ComponentUtils.wrapTooltips(List.of(Component.translatable((String)"screens.wynntils.settingsScreen.toggleOverlay", (Object[])new Object[]{configurable.getTranslatedName()})), 150);
        }
        boolean enabled = false;
        if (configurable instanceof Overlay) {
            Overlay selectedOverlay = (Overlay)configurable;
            enabled = Managers.Overlay.isEnabled(selectedOverlay);
        } else if (configurable instanceof Feature) {
            Feature selectedFeature = (Feature)configurable;
            enabled = selectedFeature.isEnabled();
        }
        this.enabledCheckbox = new WynntilsCheckbox(x + width - 10, y, 10, (Component)Component.literal((String)""), enabled, 0);
        this.maskTopY = this.settingsScreen.getMaskTopY();
        this.maskBottomY = this.settingsScreen.getConfigurableMaskBottomY();
        this.matchingConfigs = matchingConfigs;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        CustomNameProperty customNameProperty;
        WynntilsBookSettingsScreen bookSettingsScreen;
        PoseStack poseStack = guiGraphics.pose();
        if (this.isHovered && (mouseY <= this.maskTopY || mouseY >= this.maskBottomY)) {
            this.isHovered = false;
        }
        CustomColor color = this.isHovered ? CommonColors.YELLOW : CommonColors.WHITE;
        Screen screen = McUtils.screen();
        if (screen instanceof WynntilsBookSettingsScreen && (bookSettingsScreen = (WynntilsBookSettingsScreen)screen).getSelectedConfigurable() == this.configurable) {
            color = CommonColors.GRAY;
        }
        boolean isOverlay = this.configurable instanceof Overlay;
        Object textToRender = this.configurable.getTranslatedName();
        Configurable configurable = this.configurable;
        if (configurable instanceof CustomNameProperty && !((String)(customNameProperty = (CustomNameProperty)((Object)configurable)).getCustomName().get()).isEmpty()) {
            textToRender = (String)customNameProperty.getCustomName().get();
        }
        if (this.matchingConfigs > 0) {
            textToRender = (String)textToRender + String.valueOf(ChatFormatting.GRAY) + " [" + this.matchingConfigs + "]";
        }
        FontRenderer.getInstance().renderScrollingText(poseStack, StyledText.fromString((String)textToRender), isOverlay ? this.getX() + 12 : this.getX(), this.getY(), (isOverlay ? this.width - 12 : this.width) - 11, color, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL, 1.0f);
        this.enabledCheckbox.render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.isHovered) {
            if (this.enabledCheckbox.isHovered()) {
                McUtils.screen().setTooltipForNextRenderPass(Lists.transform(this.toggleTooltip, Component::getVisualOrderText));
            } else if (this.configurable instanceof Feature) {
                McUtils.screen().setTooltipForNextRenderPass(Lists.transform(this.descriptionTooltip, Component::getVisualOrderText));
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (mouseY <= (double)this.maskTopY || mouseY >= (double)this.maskBottomY) {
            return false;
        }
        if (this.enabledCheckbox.isMouseOver(mouseX, mouseY)) {
            Configurable configurable = this.configurable;
            if (configurable instanceof Feature) {
                Feature feature;
                feature.setUserEnabled(!(feature = (Feature)configurable).isEnabled());
            } else if (this.configurable instanceof Overlay) {
                Optional<Config<?>> configOpt = this.configurable.getConfigOptionFromString("userEnabled");
                if (configOpt.isPresent()) {
                    Config<?> config;
                    config.setValue((Boolean)(config = configOpt.get()).get() == false);
                } else {
                    return false;
                }
            }
            configurable = McUtils.screen();
            if (configurable instanceof WynntilsBookSettingsScreen) {
                WynntilsBookSettingsScreen bookSettingsScreen = (WynntilsBookSettingsScreen)((Object)configurable);
                bookSettingsScreen.populateConfigurables();
                bookSettingsScreen.changesMade();
            }
            return this.enabledCheckbox.mouseClicked(mouseX, mouseY, button);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void onPress() {
        Screen screen = McUtils.screen();
        if (screen instanceof WynntilsBookSettingsScreen) {
            WynntilsBookSettingsScreen bookSettingsScreen = (WynntilsBookSettingsScreen)screen;
            bookSettingsScreen.setSelectedConfigurable(this.configurable);
        }
    }

    public void setY(int y) {
        super.setY(y);
        this.enabledCheckbox.setY(y);
    }

    public Configurable getConfigurable() {
        return this.configurable;
    }
}

