/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.settings.widgets;

import com.wynntils.core.persisted.config.Config;
import com.wynntils.screens.settings.widgets.GeneralSettingsButton;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.mc.McUtils;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.network.chat.Component;

public class EnumSettingsButton<E extends Enum<E>>
extends GeneralSettingsButton {
    private final Config<E> config;
    private final List<E> enumConstants;

    public EnumSettingsButton(int x, int y, Config<E> config, int maskTopY, int maskBottomY) {
        super(x, y, 90, 20, (Component)Component.literal((String)config.getValueString()), ComponentUtils.wrapTooltips(List.of(Component.literal((String)config.getDescription())), 150), maskTopY, maskBottomY);
        this.config = config;
        this.enumConstants = EnumSet.allOf((Class)config.getType()).stream().toList();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int addToIndex;
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        if (button == 0) {
            addToIndex = 1;
        } else if (button == 1) {
            addToIndex = -1;
        } else {
            return false;
        }
        Enum value = (Enum)this.config.get();
        int nextIndex = (this.enumConstants.indexOf(value) + addToIndex + this.enumConstants.size()) % this.enumConstants.size();
        Enum nextValue = (Enum)this.enumConstants.get(nextIndex);
        this.config.setValue(nextValue);
        this.setMessage((Component)Component.literal((String)this.config.getValueString()));
        this.playDownSound(McUtils.mc().getSoundManager());
        return true;
    }

    public void onPress() {
    }
}

