/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.transcription.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.wynnalphabet.WynnAlphabet;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class WynnAlphabetButton
extends WynntilsButton {
    private final WynnAlphabet wynnAlphabet;

    public WynnAlphabetButton(int x, int y, int width, int height, WynnAlphabet wynnAlphabet) {
        super(x, y, width, height, (Component)Component.literal((String)"Wynn Alphabet Button"));
        this.wynnAlphabet = wynnAlphabet;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.wynnAlphabet == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        RenderUtils.drawRect(poseStack, CommonColors.BLACK.withAlpha(this.isHovered ? 0.7f : 0.5f), this.getX(), this.getY(), 0.0f, this.width, this.height);
        CustomColor color = this.getButtonColor();
        FontRenderer.getInstance().renderAlignedTextInBox(poseStack, switch (this.wynnAlphabet) {
            case WynnAlphabet.WYNNIC -> StyledText.fromString("W");
            case WynnAlphabet.GAVELLIAN -> StyledText.fromString("G");
            default -> StyledText.fromString("N");
        }, this.getX() + 1, this.getX() + this.width, this.getY() + 1, this.getY() + this.height, 0.0f, color, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.OUTLINE);
    }

    private CustomColor getButtonColor() {
        if (Models.WynnAlphabet.getSelectedAlphabet() == this.wynnAlphabet) {
            return CommonColors.GREEN;
        }
        return CommonColors.WHITE;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        Models.WynnAlphabet.setSelectedAlphabet(this.wynnAlphabet);
        return false;
    }

    public void onPress() {
    }
}

