/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.chat.type;

import com.wynntils.core.WynntilsMod;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.client.gui.components.ChatComponent;

public final class ChatTabData {
    private final ChatComponent chatComponent;
    private boolean hasUnreadMessages;
    private final Optional<Pattern> customRegex;

    public ChatTabData(ChatComponent chatComponent, boolean hasUnreadMessages, Optional<Pattern> customRegex) {
        this.chatComponent = chatComponent;
        this.hasUnreadMessages = hasUnreadMessages;
        this.customRegex = customRegex;
    }

    public ChatTabData(ChatComponent chatComponent, boolean hasUnreadMessages, String customRegexString) {
        this(chatComponent, hasUnreadMessages, Optional.ofNullable(ChatTabData.compileRegex(customRegexString)));
    }

    private static Pattern compileRegex(String customRegexString) {
        if (customRegexString != null && !customRegexString.isBlank()) {
            try {
                return Pattern.compile(customRegexString, 32);
            }
            catch (PatternSyntaxException e) {
                WynntilsMod.warn("Got a saved invalid chat tab regex: " + customRegexString);
                return null;
            }
        }
        return null;
    }

    public ChatComponent getChatComponent() {
        return this.chatComponent;
    }

    public boolean hasUnreadMessages() {
        return this.hasUnreadMessages;
    }

    public void setUnreadMessages(boolean hasUnreadMessages) {
        this.hasUnreadMessages = hasUnreadMessages;
    }

    public Optional<Pattern> getCustomRegex() {
        return this.customRegex;
    }

    public String toString() {
        return "ChatTabData[chatComponent=" + String.valueOf(this.chatComponent) + ", hasUnreadMessages=" + this.hasUnreadMessages + ", customRegex=" + String.valueOf(this.customRegex) + "]";
    }
}

