/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.cosmetics.type;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Services;
import com.wynntils.features.embellishments.WynntilsCosmeticsFeature;
import com.wynntils.mc.extension.EntityRenderStateExtension;
import com.wynntils.services.cosmetics.type.WynntilsLayer;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public final class WynntilsElytraLayer
extends WynntilsLayer {
    private final ElytraModel elytraModel;

    public WynntilsElytraLayer(RenderLayerParent<PlayerRenderState, PlayerModel> renderLayerParent, EntityRendererProvider.Context renderProviderContext) {
        super(renderLayerParent);
        this.elytraModel = new ElytraModel(renderProviderContext.getModelSet().bakeLayer(ModelLayers.ELYTRA));
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, PlayerRenderState playerRenderState, float yRot, float xRot) {
        if (!Managers.Feature.getFeatureInstance(WynntilsCosmeticsFeature.class).isEnabled()) {
            return;
        }
        Entity entity = ((EntityRenderStateExtension)playerRenderState).getEntity();
        if (!(entity instanceof AbstractClientPlayer)) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)entity;
        if (!Services.Cosmetics.shouldRenderCape((Player)player, true)) {
            return;
        }
        ResourceLocation texture = Services.Cosmetics.getCapeTexture((Player)player);
        if (texture == null) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 0.125f);
        this.elytraModel.setupAnim((HumanoidRenderState)playerRenderState);
        VertexConsumer vertexConsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)buffer, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)texture), (boolean)false);
        this.elytraModel.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }
}

