/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.itemfilter.statproviders;

import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.items.game.CraftedGearItem;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.services.itemfilter.type.ItemProviderType;
import com.wynntils.services.itemfilter.type.ItemStatProvider;
import java.util.List;
import java.util.Optional;

public class HealthStatProvider
extends ItemStatProvider<Integer> {
    @Override
    public Optional<Integer> getValue(WynnItem wynnItem) {
        if (wynnItem instanceof GearItem) {
            GearItem gearItem = (GearItem)wynnItem;
            return Optional.of(gearItem.getItemInfo().fixedStats().healthBuff());
        }
        if (wynnItem instanceof CraftedGearItem) {
            CraftedGearItem craftedGearItem = (CraftedGearItem)wynnItem;
            return Optional.of(craftedGearItem.getHealth());
        }
        return Optional.empty();
    }

    @Override
    public List<ItemProviderType> getFilterTypes() {
        return List.of(ItemProviderType.GEAR, ItemProviderType.GEAR_INSTANCE);
    }
}

