/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.splashes;

import com.google.common.reflect.TypeToken;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Service;
import com.wynntils.core.net.DownloadRegistry;
import com.wynntils.core.net.UrlId;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public final class SplashService
extends Service {
    private static final String DEFAULT_SPLASH = "The best Wynncraft mod you'll probably find!";
    private static final Random RANDOM = new Random();
    private List<String> allSplashes = new ArrayList<String>();
    private String currentSplash = "The best Wynncraft mod you'll probably find!";

    public SplashService() {
        super(List.of());
    }

    @Override
    public void registerDownloads(DownloadRegistry registry) {
        registry.registerDownload(UrlId.DATA_STATIC_SPLASHES).handleReader(this::handleCurrentSplash);
    }

    public String getCurrentSplash() {
        return this.currentSplash;
    }

    private void handleCurrentSplash(Reader reader) {
        Type type = new TypeToken<List<String>>(){}.getType();
        this.allSplashes = (List)WynntilsMod.GSON.fromJson(reader, type);
        this.currentSplash = this.allSplashes.isEmpty() ? DEFAULT_SPLASH : this.allSplashes.get(RANDOM.nextInt(this.allSplashes.size()));
    }
}

