/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.statistics.type;

import com.google.common.base.CaseFormat;
import com.wynntils.services.statistics.CustomStatFormatters;
import com.wynntils.services.statistics.type.StatFormatter;
import java.util.Locale;
import net.minecraft.client.resources.language.I18n;

public enum StatisticKind {
    DAMAGE_DEALT(CustomStatFormatters.FORMATTED_NUMBER, StatisticType.ADVANCED),
    SPELLS_CAST(CustomStatFormatters.FORMATTED_NUMBER, StatisticType.COUNT),
    MYTHICS_FOUND(CustomStatFormatters.FORMATTED_NUMBER, StatisticType.COUNT),
    LOOTRUNS_COMPLETED(CustomStatFormatters.FORMATTED_NUMBER, StatisticType.COUNT),
    LOOTRUNS_FAILED(CustomStatFormatters.FORMATTED_NUMBER, StatisticType.COUNT),
    LOOTRUNS_CHALLENGES_COMPLETED(CustomStatFormatters.FORMATTED_NUMBER, StatisticType.ADVANCED),
    LOOTRUNS_PULLS_WITHOUT_MYTHIC(CustomStatFormatters.FORMATTED_NUMBER, StatisticType.ADVANCED),
    LOOTRUNS_TIME_ELAPSED(CustomStatFormatters.TIME, StatisticType.ADVANCED),
    LOOTRUNS_REWARD_PULLS(CustomStatFormatters.FORMATTED_NUMBER, StatisticType.ADVANCED),
    LOOTRUNS_REWARD_REROLLS(CustomStatFormatters.FORMATTED_NUMBER, StatisticType.ADVANCED),
    LOOTRUNS_EXPERIENCE_GAINED(CustomStatFormatters.FORMATTED_NUMBER, StatisticType.ADVANCED),
    LOOTRUNS_MOBS_KILLED(CustomStatFormatters.FORMATTED_NUMBER, StatisticType.ADVANCED),
    LOOTRUNS_CHESTS_OPENED(CustomStatFormatters.FORMATTED_NUMBER, StatisticType.COUNT),
    NEST_OF_THE_GROOTSLANGS_FAILED(CustomStatFormatters.FORMATTED_NUMBER, StatisticType.COUNT),
    NEST_OF_THE_GROOTSLANGS_SUCCEEDED(CustomStatFormatters.FORMATTED_NUMBER, StatisticType.COUNT),
    NEST_OF_THE_GROOTSLANGS_TIME_ELAPSED(CustomStatFormatters.TIME, StatisticType.ADVANCED),
    ORPHIONS_NEXUS_OF_LIGHT_FAILED(CustomStatFormatters.FORMATTED_NUMBER, StatisticType.COUNT),
    ORPHIONS_NEXUS_OF_LIGHT_SUCCEEDED(CustomStatFormatters.FORMATTED_NUMBER, StatisticType.COUNT),
    ORPHIONS_NEXUS_OF_LIGHT_TIME_ELAPSED(CustomStatFormatters.TIME, StatisticType.ADVANCED),
    THE_CANYON_COLOSSUS_FAILED(CustomStatFormatters.FORMATTED_NUMBER, StatisticType.COUNT),
    THE_CANYON_COLOSSUS_SUCCEEDED(CustomStatFormatters.FORMATTED_NUMBER, StatisticType.COUNT),
    THE_CANYON_COLOSSUS_TIME_ELAPSED(CustomStatFormatters.TIME, StatisticType.ADVANCED),
    THE_NAMELESS_ANOMALY_FAILED(CustomStatFormatters.FORMATTED_NUMBER, StatisticType.COUNT),
    THE_NAMELESS_ANOMALY_SUCCEEDED(CustomStatFormatters.FORMATTED_NUMBER, StatisticType.COUNT),
    THE_NAMELESS_ANOMALY_TIME_ELAPSED(CustomStatFormatters.TIME, StatisticType.ADVANCED),
    WARS_JOINED(CustomStatFormatters.FORMATTED_NUMBER, StatisticType.COUNT),
    ANNIHILATIONS_COMPLETED(CustomStatFormatters.FORMATTED_NUMBER, StatisticType.COUNT),
    ANNIHILATIONS_FAILED(CustomStatFormatters.FORMATTED_NUMBER, StatisticType.COUNT),
    CORRUPTED_CACHES_FOUND(CustomStatFormatters.FORMATTED_NUMBER, StatisticType.COUNT);

    private final StatFormatter formatter;
    private final StatisticType type;
    private final String id;

    private StatisticKind(StatFormatter formatter, StatisticType type) {
        this.formatter = formatter;
        this.type = type;
        this.id = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.name().toLowerCase(Locale.ROOT));
    }

    public static StatisticKind from(String statisticId) {
        for (StatisticKind statisticKind : StatisticKind.values()) {
            if (!statisticKind.getId().equals(statisticId)) continue;
            return statisticKind;
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public StatisticType getType() {
        return this.type;
    }

    public String getName() {
        return I18n.get((String)("statistics.wynntils." + this.id + ".name"), (Object[])new Object[0]);
    }

    public String getFormattedValue(long value) {
        return this.formatter.format(value);
    }

    public static enum StatisticType {
        COUNT,
        ADVANCED;

    }
}

