/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.mc;

import com.wynntils.core.text.StyledText;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import java.util.Arrays;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;

public final class RenderedStringUtils {
    private static final Pattern OPENING_PARENTHESIS_PATTERN = Pattern.compile(" \\(");
    private static final Pattern OPENING_BRACKET_PATTERN = Pattern.compile(" \\[");

    public static StyledText[] wrapTextBySize(StyledText s, int maxPixels) {
        Font font = McUtils.mc().font;
        int spaceSize = font.width(" ");
        StyledText[] stringArray = s.split(" ");
        StringBuilder result = new StringBuilder();
        int length = 0;
        for (StyledText string : stringArray) {
            StyledText[] lines = string.split("\\\\n");
            for (int i = 0; i < lines.length; ++i) {
                StyledText line = lines[i];
                if (i > 0 || length + font.width(line.getString()) >= maxPixels) {
                    result.append('\n');
                    length = 0;
                }
                if (line.isEmpty()) continue;
                result.append(line.getString()).append(' ');
                length += font.width(line.getString()) + spaceSize;
            }
        }
        return (StyledText[])Arrays.stream(result.toString().split("\n")).map(StyledText::fromString).toArray(StyledText[]::new);
    }

    public static String getMaxFittingText(String text, float maxTextWidth, Font font) {
        if ((float)font.width(text) < maxTextWidth) {
            return text;
        }
        StringBuilder builder = new StringBuilder();
        int suffixWidth = font.width("...");
        for (int stringPosition = 0; (float)font.width(builder.toString()) < maxTextWidth - (float)suffixWidth && stringPosition < text.length(); ++stringPosition) {
            builder.append(text.charAt(stringPosition));
        }
        builder.append("...");
        String renderedText = builder.toString();
        return renderedText;
    }

    public static StyledText trySplitOptimally(StyledText line, float maxWidth) {
        String maxFitting = RenderedStringUtils.getMaxFittingText(line.getStringWithoutFormatting(), maxWidth, FontRenderer.getInstance().getFont());
        if (maxFitting.contains("[") && !maxFitting.contains("]")) {
            String color = "";
            if (line.startsWith("\u00a7")) {
                color = line.getString().substring(0, 2);
            }
            return StyledText.fromString(OPENING_BRACKET_PATTERN.matcher(line.getString()).replaceFirst("\n" + color + "["));
        }
        if (maxFitting.contains("(") && !maxFitting.contains(")")) {
            String color = "";
            if (line.startsWith("\u00a7")) {
                color = line.getString().substring(0, 2);
            }
            return StyledText.fromString(OPENING_PARENTHESIS_PATTERN.matcher(line.getString()).replaceFirst("\n" + color + "("));
        }
        return line;
    }

    public static String substringMaxWidth(String input, int maxWidth) {
        Font font = McUtils.mc().font;
        if (font.width(input) <= maxWidth) {
            return input;
        }
        StringBuilder builder = new StringBuilder();
        for (char c : input.toCharArray()) {
            if (font.width(builder.toString() + c) > maxWidth) break;
            builder.append(c);
        }
        return builder.toString();
    }

    public static Component getPercentageComponent(int count, int totalCount, int tickCount) {
        return RenderedStringUtils.getPercentageComponent(count, totalCount, tickCount, false, "");
    }

    public static Component getPercentageComponent(int count, int totalCount, int tickCount, boolean displayRawCount, String amountSuffix) {
        ChatFormatting foregroundColor;
        ChatFormatting braceColor;
        int percentage = Math.round((float)count / (float)totalCount * 100.0f);
        if (percentage < 25) {
            braceColor = ChatFormatting.DARK_RED;
            foregroundColor = ChatFormatting.RED;
        } else if (percentage < 75) {
            braceColor = ChatFormatting.GOLD;
            foregroundColor = ChatFormatting.YELLOW;
        } else {
            braceColor = ChatFormatting.DARK_GREEN;
            foregroundColor = ChatFormatting.GREEN;
        }
        StringBuilder insideText = new StringBuilder(foregroundColor.toString());
        if (displayRawCount) {
            insideText.append("|".repeat(tickCount)).append(count).append(amountSuffix).append("|".repeat(tickCount));
        } else {
            insideText.append("|".repeat(tickCount)).append(percentage).append("%").append("|".repeat(tickCount));
        }
        int insertAt = Math.min(insideText.length(), Math.round((float)(insideText.length() - 2) * (float)count / (float)totalCount) + 2);
        insideText.insert(insertAt, ChatFormatting.DARK_GRAY);
        return Component.literal((String)"[").withStyle(braceColor).append((Component)Component.literal((String)insideText.toString())).append((Component)Component.literal((String)"]").withStyle(braceColor));
    }
}

