/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.consumers.features;

import com.mojang.brigadier.tree.CommandNode;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Manager;
import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.FeatureCommands;
import com.wynntils.core.consumers.features.FeatureState;
import com.wynntils.core.consumers.features.properties.StartDisabled;
import com.wynntils.core.mod.type.CrashType;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.features.DiscordRichPresenceFeature;
import com.wynntils.features.ExtendedSeasonLeaderboardFeature;
import com.wynntils.features.LootrunFeature;
import com.wynntils.features.TerritoryDefenseMessageFeature;
import com.wynntils.features.ValuableFoundFeature;
import com.wynntils.features.chat.BombBellRelayFeature;
import com.wynntils.features.chat.ChatCoordinatesFeature;
import com.wynntils.features.chat.ChatItemFeature;
import com.wynntils.features.chat.ChatMentionFeature;
import com.wynntils.features.chat.ChatTabsFeature;
import com.wynntils.features.chat.ChatTimestampFeature;
import com.wynntils.features.chat.DeathCoordinatesFeature;
import com.wynntils.features.chat.DialogueOptionOverrideFeature;
import com.wynntils.features.chat.InputTranscriptionFeature;
import com.wynntils.features.chat.MessageFilterFeature;
import com.wynntils.features.chat.RemoveWynncraftChatWrapFeature;
import com.wynntils.features.chat.RevealNicknamesFeature;
import com.wynntils.features.combat.AbbreviateMobHealthFeature;
import com.wynntils.features.combat.AutoAttackFeature;
import com.wynntils.features.combat.ChestBlockerFeature;
import com.wynntils.features.combat.ContentTrackerFeature;
import com.wynntils.features.combat.CustomLootrunBeaconsFeature;
import com.wynntils.features.combat.FixCastingSpellsFromInventoryFeature;
import com.wynntils.features.combat.HealthPotionBlockerFeature;
import com.wynntils.features.combat.HideLabelsFeature;
import com.wynntils.features.combat.HorseMountFeature;
import com.wynntils.features.combat.InvertAttackKeybindsFeature;
import com.wynntils.features.combat.LowHealthVignetteFeature;
import com.wynntils.features.combat.MythicBoxScalerFeature;
import com.wynntils.features.combat.PreventTradesDuelsFeature;
import com.wynntils.features.combat.QuickCastFeature;
import com.wynntils.features.combat.RangeVisualizerFeature;
import com.wynntils.features.combat.ShamanTotemTrackingFeature;
import com.wynntils.features.combat.SpellCastVignetteFeature;
import com.wynntils.features.combat.TokenTrackerBellFeature;
import com.wynntils.features.commands.AddCommandExpansionFeature;
import com.wynntils.features.commands.CommandAliasesFeature;
import com.wynntils.features.commands.CustomCommandKeybindsFeature;
import com.wynntils.features.commands.FilterAdminCommandsFeature;
import com.wynntils.features.debug.AbilityTreeDataDumpFeature;
import com.wynntils.features.debug.ContentBookDumpFeature;
import com.wynntils.features.debug.FunctionDumpFeature;
import com.wynntils.features.debug.ItemDebugTooltipsFeature;
import com.wynntils.features.debug.LogItemInfoFeature;
import com.wynntils.features.debug.MappingProgressFeature;
import com.wynntils.features.debug.PacketDebuggerFeature;
import com.wynntils.features.embellishments.RemoveShinyGlintFeature;
import com.wynntils.features.embellishments.WarHornFeature;
import com.wynntils.features.embellishments.WybelSoundFeature;
import com.wynntils.features.embellishments.WynntilsCosmeticsFeature;
import com.wynntils.features.inventory.ContainerSearchFeature;
import com.wynntils.features.inventory.DisableRecipeBookFeature;
import com.wynntils.features.inventory.DurabilityOverlayFeature;
import com.wynntils.features.inventory.EmeraldPouchFillArcFeature;
import com.wynntils.features.inventory.EmeraldPouchHotkeyFeature;
import com.wynntils.features.inventory.ExtendedItemCountFeature;
import com.wynntils.features.inventory.GuildBankHotkeyFeature;
import com.wynntils.features.inventory.HideAttackCooldownFeature;
import com.wynntils.features.inventory.IngredientPouchHotkeyFeature;
import com.wynntils.features.inventory.InventoryEmeraldCountFeature;
import com.wynntils.features.inventory.ItemFavoriteFeature;
import com.wynntils.features.inventory.ItemHighlightFeature;
import com.wynntils.features.inventory.ItemLockFeature;
import com.wynntils.features.inventory.ItemScreenshotFeature;
import com.wynntils.features.inventory.ItemTextOverlayFeature;
import com.wynntils.features.inventory.LootchestTextFeature;
import com.wynntils.features.inventory.PersonalStorageUtilitiesFeature;
import com.wynntils.features.inventory.UnidentifiedItemIconFeature;
import com.wynntils.features.map.BeaconBeamFeature;
import com.wynntils.features.map.GuildMapFeature;
import com.wynntils.features.map.MainMapFeature;
import com.wynntils.features.map.MinimapFeature;
import com.wynntils.features.map.WorldWaypointDistanceFeature;
import com.wynntils.features.overlays.AnnihilationSunOverlayFeature;
import com.wynntils.features.overlays.ArrowShieldTrackerOverlayFeature;
import com.wynntils.features.overlays.BombBellOverlayFeature;
import com.wynntils.features.overlays.BonusTotemTimerOverlayFeature;
import com.wynntils.features.overlays.CombatExperienceOverlayFeature;
import com.wynntils.features.overlays.ContentTrackerOverlayFeature;
import com.wynntils.features.overlays.CustomBarsOverlayFeature;
import com.wynntils.features.overlays.CustomPlayerListOverlayFeature;
import com.wynntils.features.overlays.GameBarsOverlayFeature;
import com.wynntils.features.overlays.GameNotificationOverlayFeature;
import com.wynntils.features.overlays.GuardianAngelsTrackerOverlayFeature;
import com.wynntils.features.overlays.HeldItemCooldownOverlayFeature;
import com.wynntils.features.overlays.InfoBoxFeature;
import com.wynntils.features.overlays.LootrunOverlaysFeature;
import com.wynntils.features.overlays.MantleShieldTrackerOverlayFeature;
import com.wynntils.features.overlays.NpcDialogueFeature;
import com.wynntils.features.overlays.ObjectivesOverlayFeature;
import com.wynntils.features.overlays.PartyMembersOverlayFeature;
import com.wynntils.features.overlays.PowderSpecialBarOverlayFeature;
import com.wynntils.features.overlays.RaidProgressFeature;
import com.wynntils.features.overlays.ServerUptimeInfoOverlayFeature;
import com.wynntils.features.overlays.ShamanMaskOverlayFeature;
import com.wynntils.features.overlays.ShamanTotemTimerOverlayFeature;
import com.wynntils.features.overlays.SpellCastMessageOverlayFeature;
import com.wynntils.features.overlays.StatusEffectsOverlayFeature;
import com.wynntils.features.overlays.StopwatchFeature;
import com.wynntils.features.overlays.StreamerModeOverlayFeature;
import com.wynntils.features.overlays.TerritoryAttackTimerOverlayFeature;
import com.wynntils.features.overlays.TokenBarsOverlayFeature;
import com.wynntils.features.overlays.TowerEffectOverlayFeature;
import com.wynntils.features.overlays.TowerStatsFeature;
import com.wynntils.features.players.AutoJoinPartyFeature;
import com.wynntils.features.players.CustomNametagRendererFeature;
import com.wynntils.features.players.HadesFeature;
import com.wynntils.features.players.PartyManagementScreenFeature;
import com.wynntils.features.players.PlayerArmorHidingFeature;
import com.wynntils.features.players.PlayerGhostTransparencyFeature;
import com.wynntils.features.players.PlayerViewerFeature;
import com.wynntils.features.redirects.AbilityRefreshRedirectFeature;
import com.wynntils.features.redirects.ChatRedirectFeature;
import com.wynntils.features.redirects.InventoryRedirectFeature;
import com.wynntils.features.redirects.TerritoryMessageRedirectFeature;
import com.wynntils.features.tooltips.ItemCompareFeature;
import com.wynntils.features.tooltips.ItemGuessFeature;
import com.wynntils.features.tooltips.ItemStatInfoFeature;
import com.wynntils.features.tooltips.TooltipFittingFeature;
import com.wynntils.features.tooltips.TooltipVanillaHideFeature;
import com.wynntils.features.trademarket.TradeMarketBulkSellFeature;
import com.wynntils.features.trademarket.TradeMarketPriceConversionFeature;
import com.wynntils.features.trademarket.TradeMarketPriceMatchFeature;
import com.wynntils.features.trademarket.TradeMarketQuickSearchFeature;
import com.wynntils.features.ui.BulkBuyFeature;
import com.wynntils.features.ui.ContainerScrollFeature;
import com.wynntils.features.ui.CraftingProfessionLevelProgressBarFeature;
import com.wynntils.features.ui.CustomGuildLogScreenFeature;
import com.wynntils.features.ui.CustomLoadingScreenFeature;
import com.wynntils.features.ui.CustomSeaskipperScreenFeature;
import com.wynntils.features.ui.CustomTerritoryManagementScreenFeature;
import com.wynntils.features.ui.CustomTradeMarketResultScreenFeature;
import com.wynntils.features.ui.LobbyUptimeFeature;
import com.wynntils.features.ui.ProfessionHighlightFeature;
import com.wynntils.features.ui.WynncraftButtonFeature;
import com.wynntils.features.ui.WynncraftPauseScreenFeature;
import com.wynntils.features.ui.WynntilsContentBookFeature;
import com.wynntils.features.utilities.AutoApplyResourcePackFeature;
import com.wynntils.features.utilities.AutoSkipCutscenesFeature;
import com.wynntils.features.utilities.CharacterSelectionUtilitiesFeature;
import com.wynntils.features.utilities.FixCrosshairPositionFeature;
import com.wynntils.features.utilities.GammabrightFeature;
import com.wynntils.features.utilities.PerCharacterGuildContributionFeature;
import com.wynntils.features.utilities.SilencerFeature;
import com.wynntils.features.utilities.SkillPointLoadoutsFeature;
import com.wynntils.features.utilities.TranscribeMessagesFeature;
import com.wynntils.features.utilities.TranslationFeature;
import com.wynntils.features.utilities.ValuablesProtectionFeature;
import com.wynntils.features.utilities.XpGainMessageFeature;
import com.wynntils.features.wynntils.BetaWarningFeature;
import com.wynntils.features.wynntils.ChangelogFeature;
import com.wynntils.features.wynntils.CommandsFeature;
import com.wynntils.features.wynntils.DataCrowdSourcingFeature;
import com.wynntils.features.wynntils.DownloadProgressFeature;
import com.wynntils.features.wynntils.FixPacketBugsFeature;
import com.wynntils.features.wynntils.TelemetryFeature;
import com.wynntils.features.wynntils.UpdatesFeature;
import com.wynntils.features.wynntils.WeeklyConfigBackupFeature;
import com.wynntils.features.wynntils.WynntilsHintMessagesFeature;
import com.wynntils.mc.event.CommandsAddedEvent;
import com.wynntils.mc.event.SystemMessageEvent;
import com.wynntils.utils.mc.McUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2172;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_315;
import net.minecraft.class_5250;
import net.minecraft.class_7172;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;

public final class FeatureManager
extends Manager {
    private static final Map<Feature, FeatureState> FEATURES = new LinkedHashMap<Feature, FeatureState>();
    private static final Map<Class<? extends Feature>, Feature> FEATURE_INSTANCES = new LinkedHashMap<Class<? extends Feature>, Feature>();
    private final FeatureCommands commands = new FeatureCommands();

    public FeatureManager() {
        super(List.of());
    }

    @SubscribeEvent
    public void onCommandsAdded(CommandsAddedEvent event) {
        Managers.Command.addNode(event.getRoot(), (CommandNode<? extends class_2172>)this.commands.getCommandNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        this.registerFeature(new AbilityTreeDataDumpFeature());
        this.registerFeature(new ContentBookDumpFeature());
        this.registerFeature(new FunctionDumpFeature());
        this.registerFeature(new ItemDebugTooltipsFeature());
        this.registerFeature(new LogItemInfoFeature());
        this.registerFeature(new MappingProgressFeature());
        this.registerFeature(new PacketDebuggerFeature());
        this.registerFeature(new LootrunFeature());
        this.registerFeature(new BombBellRelayFeature());
        this.registerFeature(new ChatCoordinatesFeature());
        this.registerFeature(new ChatItemFeature());
        this.registerFeature(new ChatMentionFeature());
        this.registerFeature(new ChatTabsFeature());
        this.registerFeature(new ChatTimestampFeature());
        this.registerFeature(new DeathCoordinatesFeature());
        this.registerFeature(new DialogueOptionOverrideFeature());
        this.registerFeature(new InputTranscriptionFeature());
        this.registerFeature(new MessageFilterFeature());
        this.registerFeature(new RemoveWynncraftChatWrapFeature());
        this.registerFeature(new RevealNicknamesFeature());
        this.registerFeature(new AbbreviateMobHealthFeature());
        this.registerFeature(new AutoAttackFeature());
        this.registerFeature(new ChestBlockerFeature());
        this.registerFeature(new ContentTrackerFeature());
        this.registerFeature(new CustomLootrunBeaconsFeature());
        this.registerFeature(new FixCastingSpellsFromInventoryFeature());
        this.registerFeature(new HealthPotionBlockerFeature());
        this.registerFeature(new HideLabelsFeature());
        this.registerFeature(new HorseMountFeature());
        this.registerFeature(new InvertAttackKeybindsFeature());
        this.registerFeature(new LowHealthVignetteFeature());
        this.registerFeature(new MythicBoxScalerFeature());
        this.registerFeature(new PreventTradesDuelsFeature());
        this.registerFeature(new QuickCastFeature());
        this.registerFeature(new RangeVisualizerFeature());
        this.registerFeature(new ShamanTotemTrackingFeature());
        this.registerFeature(new SpellCastVignetteFeature());
        this.registerFeature(new TokenTrackerBellFeature());
        this.registerFeature(new AddCommandExpansionFeature());
        this.registerFeature(new CommandAliasesFeature());
        this.registerFeature(new CustomCommandKeybindsFeature());
        this.registerFeature(new FilterAdminCommandsFeature());
        this.registerFeature(new RemoveShinyGlintFeature());
        this.registerFeature(new WarHornFeature());
        this.registerFeature(new WybelSoundFeature());
        this.registerFeature(new WynntilsCosmeticsFeature());
        this.registerFeature(new ContainerSearchFeature());
        this.registerFeature(new DisableRecipeBookFeature());
        this.registerFeature(new DurabilityOverlayFeature());
        this.registerFeature(new EmeraldPouchFillArcFeature());
        this.registerFeature(new EmeraldPouchHotkeyFeature());
        this.registerFeature(new ExtendedItemCountFeature());
        this.registerFeature(new GuildBankHotkeyFeature());
        this.registerFeature(new HideAttackCooldownFeature());
        this.registerFeature(new IngredientPouchHotkeyFeature());
        this.registerFeature(new InventoryEmeraldCountFeature());
        this.registerFeature(new ItemFavoriteFeature());
        this.registerFeature(new ItemHighlightFeature());
        this.registerFeature(new ItemLockFeature());
        this.registerFeature(new ItemScreenshotFeature());
        this.registerFeature(new ItemTextOverlayFeature());
        this.registerFeature(new LootchestTextFeature());
        this.registerFeature(new PersonalStorageUtilitiesFeature());
        this.registerFeature(new UnidentifiedItemIconFeature());
        this.registerFeature(new BeaconBeamFeature());
        this.registerFeature(new GuildMapFeature());
        this.registerFeature(new MainMapFeature());
        this.registerFeature(new MinimapFeature());
        this.registerFeature(new WorldWaypointDistanceFeature());
        this.registerFeature(new AnnihilationSunOverlayFeature());
        this.registerFeature(new ArrowShieldTrackerOverlayFeature());
        this.registerFeature(new BombBellOverlayFeature());
        this.registerFeature(new BonusTotemTimerOverlayFeature());
        this.registerFeature(new CombatExperienceOverlayFeature());
        this.registerFeature(new ContentTrackerOverlayFeature());
        this.registerFeature(new CustomBarsOverlayFeature());
        this.registerFeature(new CustomPlayerListOverlayFeature());
        this.registerFeature(new GameBarsOverlayFeature());
        this.registerFeature(new GameNotificationOverlayFeature());
        this.registerFeature(new GuardianAngelsTrackerOverlayFeature());
        this.registerFeature(new HeldItemCooldownOverlayFeature());
        this.registerFeature(new InfoBoxFeature());
        this.registerFeature(new LootrunOverlaysFeature());
        this.registerFeature(new MantleShieldTrackerOverlayFeature());
        this.registerFeature(new NpcDialogueFeature());
        this.registerFeature(new ObjectivesOverlayFeature());
        this.registerFeature(new PartyMembersOverlayFeature());
        this.registerFeature(new PowderSpecialBarOverlayFeature());
        this.registerFeature(new RaidProgressFeature());
        this.registerFeature(new ServerUptimeInfoOverlayFeature());
        this.registerFeature(new ShamanMaskOverlayFeature());
        this.registerFeature(new ShamanTotemTimerOverlayFeature());
        this.registerFeature(new SpellCastMessageOverlayFeature());
        this.registerFeature(new StatusEffectsOverlayFeature());
        this.registerFeature(new StopwatchFeature());
        this.registerFeature(new StreamerModeOverlayFeature());
        this.registerFeature(new TerritoryAttackTimerOverlayFeature());
        this.registerFeature(new TokenBarsOverlayFeature());
        this.registerFeature(new TowerEffectOverlayFeature());
        this.registerFeature(new TowerStatsFeature());
        this.registerFeature(new AutoJoinPartyFeature());
        this.registerFeature(new CustomNametagRendererFeature());
        this.registerFeature(new HadesFeature());
        this.registerFeature(new PartyManagementScreenFeature());
        this.registerFeature(new PlayerArmorHidingFeature());
        this.registerFeature(new PlayerGhostTransparencyFeature());
        this.registerFeature(new PlayerViewerFeature());
        this.registerFeature(new AbilityRefreshRedirectFeature());
        this.registerFeature(new ChatRedirectFeature());
        this.registerFeature(new InventoryRedirectFeature());
        this.registerFeature(new TerritoryMessageRedirectFeature());
        this.registerFeature(new ItemCompareFeature());
        this.registerFeature(new ItemGuessFeature());
        this.registerFeature(new ItemStatInfoFeature());
        this.registerFeature(new TooltipFittingFeature());
        this.registerFeature(new TooltipVanillaHideFeature());
        this.registerFeature(new TradeMarketBulkSellFeature());
        this.registerFeature(new TradeMarketPriceConversionFeature());
        this.registerFeature(new TradeMarketPriceMatchFeature());
        this.registerFeature(new TradeMarketQuickSearchFeature());
        this.registerFeature(new BulkBuyFeature());
        this.registerFeature(new ContainerScrollFeature());
        this.registerFeature(new CraftingProfessionLevelProgressBarFeature());
        this.registerFeature(new CustomGuildLogScreenFeature());
        this.registerFeature(new CustomLoadingScreenFeature());
        this.registerFeature(new CustomSeaskipperScreenFeature());
        this.registerFeature(new CustomTerritoryManagementScreenFeature());
        this.registerFeature(new CustomTradeMarketResultScreenFeature());
        this.registerFeature(new LobbyUptimeFeature());
        this.registerFeature(new ProfessionHighlightFeature());
        this.registerFeature(new WynncraftButtonFeature());
        this.registerFeature(new WynncraftPauseScreenFeature());
        this.registerFeature(new WynntilsContentBookFeature());
        this.registerFeature(new AutoApplyResourcePackFeature());
        this.registerFeature(new AutoSkipCutscenesFeature());
        this.registerFeature(new CharacterSelectionUtilitiesFeature());
        this.registerFeature(new FixCrosshairPositionFeature());
        this.registerFeature(new GammabrightFeature());
        this.registerFeature(new ValuablesProtectionFeature());
        this.registerFeature(new PerCharacterGuildContributionFeature());
        this.registerFeature(new SilencerFeature());
        this.registerFeature(new SkillPointLoadoutsFeature());
        this.registerFeature(new TranscribeMessagesFeature());
        this.registerFeature(new TranslationFeature());
        this.registerFeature(new XpGainMessageFeature());
        this.registerFeature(new BetaWarningFeature());
        this.registerFeature(new ChangelogFeature());
        this.registerFeature(new CommandsFeature());
        this.registerFeature(new DataCrowdSourcingFeature());
        this.registerFeature(new DownloadProgressFeature());
        this.registerFeature(new FixPacketBugsFeature());
        this.registerFeature(new TelemetryFeature());
        this.registerFeature(new UpdatesFeature());
        this.registerFeature(new WeeklyConfigBackupFeature());
        this.registerFeature(new WynntilsHintMessagesFeature());
        this.registerFeature(new DiscordRichPresenceFeature());
        this.registerFeature(new ExtendedSeasonLeaderboardFeature());
        this.registerFeature(new TerritoryDefenseMessageFeature());
        this.registerFeature(new ValuableFoundFeature());
        class_315 class_3152 = McUtils.options();
        synchronized (class_3152) {
            class_315 options = McUtils.options();
            class_7172 guiScale = options.method_42474();
            int initialGuiScale = (Integer)guiScale.method_41753();
            options.method_1636();
            guiScale.field_37868 = initialGuiScale;
        }
        this.commands.init();
        this.addCrashCallbacks();
    }

    private void registerFeature(Feature feature) {
        FEATURES.put(feature, FeatureState.DISABLED);
        FEATURE_INSTANCES.put(feature.getClass(), feature);
        try {
            this.initializeFeature(feature);
        }
        catch (AssertionError ae) {
            WynntilsMod.error("Fix i18n for " + feature.getClass().getSimpleName(), (Throwable)((Object)ae));
            if (WynntilsMod.isDevelopmentEnvironment()) {
                System.exit(1);
            }
        }
        catch (Throwable exception) {
            this.crashFeature(feature);
            WynntilsMod.reportCrash(CrashType.FEATURE, feature.getClass().getSimpleName(), feature.getClass().getName(), "init", false, true, exception);
        }
    }

    private void initializeFeature(Feature feature) {
        Class<?> featureClass = feature.getClass();
        ConfigCategory configCategory = feature.getClass().getAnnotation(ConfigCategory.class);
        Category category = configCategory != null ? configCategory.value() : Category.UNCATEGORIZED;
        feature.setCategory(category);
        this.commands.discoverCommands(feature);
        Managers.KeyBind.discoverKeyBinds(feature);
        boolean startDisabled = featureClass.isAnnotationPresent(StartDisabled.class);
        feature.userEnabled.store(!startDisabled);
        Managers.Overlay.discoverOverlays(feature);
        Managers.Overlay.discoverOverlayGroups(feature);
        assert (!feature.getTranslatedName().startsWith("feature.wynntils.")) : "Fix i18n for " + feature.getTranslatedName();
        assert (!feature.getTranslatedDescription().startsWith("feature.wynntils.")) : "Fix i18n for " + feature.getTranslatedDescription();
        if (!((Boolean)feature.userEnabled.get()).booleanValue()) {
            return;
        }
        this.doEnableFeature(feature);
    }

    public void enableFeature(Feature feature) {
        try {
            this.doEnableFeature(feature);
        }
        catch (Throwable exception) {
            this.crashFeature(feature);
            WynntilsMod.reportCrash(CrashType.FEATURE, feature.getClass().getSimpleName(), feature.getClass().getName(), "enable", true, true, exception);
        }
    }

    private void doEnableFeature(Feature feature) {
        if (!FEATURES.containsKey(feature)) {
            throw new IllegalArgumentException("Tried to enable an unregistered feature: " + String.valueOf(feature));
        }
        FeatureState state = FEATURES.get(feature);
        if (state != FeatureState.DISABLED && state != FeatureState.CRASHED) {
            return;
        }
        feature.onEnable();
        FEATURES.put(feature, FeatureState.ENABLED);
        WynntilsMod.registerEventListener(feature);
        Managers.Overlay.enableOverlays(feature);
        Managers.KeyBind.enableFeatureKeyBinds(feature);
    }

    public void disableFeature(Feature feature, boolean force) {
        if (!FEATURES.containsKey(feature)) {
            throw new IllegalArgumentException("Tried to disable an unregistered feature: " + String.valueOf(feature));
        }
        FeatureState state = FEATURES.get(feature);
        if (state != FeatureState.ENABLED && !force) {
            return;
        }
        feature.onDisable();
        FEATURES.put(feature, FeatureState.DISABLED);
        WynntilsMod.unregisterEventListener(feature);
        Managers.Overlay.disableOverlays(feature);
        Managers.KeyBind.disableFeatureKeyBinds(feature);
    }

    public void crashFeature(Feature feature) {
        if (!FEATURES.containsKey(feature)) {
            throw new IllegalArgumentException("Tried to crash an unregistered feature: " + String.valueOf(feature));
        }
        this.disableFeature(feature, true);
        FEATURES.put(feature, FeatureState.CRASHED);
    }

    private FeatureState getFeatureState(Feature feature) {
        if (!FEATURES.containsKey(feature)) {
            throw new IllegalArgumentException("Feature " + String.valueOf(feature) + " is not registered, but was was queried for its state");
        }
        return FEATURES.get(feature);
    }

    public boolean isEnabled(Feature feature) {
        return this.getFeatureState(feature) == FeatureState.ENABLED;
    }

    public List<Feature> getFeatures() {
        return FEATURES.keySet().stream().toList();
    }

    public <T extends Feature> T getFeatureInstance(Class<T> featureClass) {
        Feature feature = FEATURE_INSTANCES.get(featureClass);
        if (!featureClass.isInstance(feature)) {
            throw new IllegalArgumentException("Feature " + String.valueOf(featureClass) + " is not registered");
        }
        return (T)((Feature)featureClass.cast(feature));
    }

    public Optional<Feature> getFeatureFromString(String featureName) {
        return this.getFeatures().stream().filter(feature -> feature.getShortName().equals(featureName)).findFirst();
    }

    public void handleExceptionInEventListener(Event event, String featureClassName, Throwable t) {
        String featureName = featureClassName.substring(featureClassName.lastIndexOf(46) + 1);
        Optional<Feature> featureOptional = this.getFeatureFromString(featureName);
        if (featureOptional.isEmpty()) {
            WynntilsMod.error("Exception in event listener in feature that cannot be located: " + featureClassName, t);
            return;
        }
        Feature feature = featureOptional.get();
        this.crashFeature(feature);
        boolean shouldSendChat = !(event instanceof SystemMessageEvent.ChatReceivedEvent);
        WynntilsMod.reportCrash(CrashType.FEATURE, feature.getTranslatedName(), feature.getClass().getName(), "event listener", shouldSendChat, true, t);
        if (shouldSendChat) {
            class_5250 enableMessage = class_2561.method_43470((String)"Click here to enable it again.").method_27692(class_124.field_1073).method_27692(class_124.field_1061).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/feature enable " + feature.getShortName())));
            McUtils.sendMessageToClient((class_2561)enableMessage);
        }
    }

    private void addCrashCallbacks() {
        Managers.CrashReport.registerCrashContext("Loaded Features", () -> {
            StringBuilder result = new StringBuilder();
            for (Feature feature : FEATURES.keySet()) {
                if (!feature.isEnabled()) continue;
                result.append("\n\t\t").append(feature.getTranslatedName());
            }
            return result.toString();
        });
    }
}

