/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.consumers.functions;

import com.google.common.base.CaseFormat;
import com.wynntils.core.consumers.functions.arguments.FunctionArguments;
import com.wynntils.core.persisted.Translatable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

public abstract class Function<T>
implements Translatable {
    private final String name;
    private List<String> aliases;

    protected Function() {
        String name = this.getClass().getSimpleName().replace("Function", "");
        this.name = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name);
    }

    @Override
    public String getTypeName() {
        return "Function";
    }

    public abstract T getValue(FunctionArguments var1);

    public FunctionArguments.Builder getArgumentsBuilder() {
        return FunctionArguments.OptionalArgumentBuilder.EMPTY;
    }

    public String getName() {
        return this.name;
    }

    protected List<String> getAliases() {
        return List.of();
    }

    public final List<String> getAliasList() {
        if (this.aliases == null) {
            this.aliases = this.getAliases();
        }
        return this.aliases;
    }

    public String getDescription() {
        return this.getTranslation("description", new Object[0]);
    }

    public String getArgumentDescription(String argumentName) {
        return this.getTranslation("argument." + argumentName, new Object[0]);
    }

    public String getReturnTypeName() {
        Type typeArgument = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        if (typeArgument instanceof Class) {
            Class clazz = (Class)typeArgument;
            return clazz.getSimpleName();
        }
        assert (false);
        return typeArgument.getTypeName();
    }
}

