/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.consumers.functions.templates.parser;

import com.wynntils.core.consumers.functions.templates.ExpressionTemplatePart;
import com.wynntils.core.consumers.functions.templates.LiteralTemplatePart;
import com.wynntils.core.consumers.functions.templates.Template;
import com.wynntils.core.consumers.functions.templates.TemplatePart;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class TemplateParser {
    public static Template getTemplateFromString(String templateString) {
        List<TemplatePart> parts = TemplateParser.parseTemplate(templateString);
        return new Template(Collections.unmodifiableList(parts));
    }

    private static List<TemplatePart> parseTemplate(String templateString) {
        ArrayList<TemplatePart> parts = new ArrayList<TemplatePart>();
        int lastIndexOfExpressionEnd = templateString.lastIndexOf(125);
        int expressionContextStart = -1;
        int expressionNestLevel = 0;
        int processedUntil = 0;
        for (int i = 0; i < templateString.length(); ++i) {
            char current = templateString.charAt(i);
            if (current == '{') {
                if (expressionContextStart != -1) {
                    ++expressionNestLevel;
                    continue;
                }
                if (processedUntil != i) {
                    parts.add(new LiteralTemplatePart(templateString.substring(processedUntil, i)));
                    processedUntil = i;
                }
                expressionContextStart = i;
                continue;
            }
            if (current != '}' || expressionContextStart == -1) continue;
            if (expressionNestLevel != 0 && i != lastIndexOfExpressionEnd) {
                --expressionNestLevel;
                continue;
            }
            String expression = templateString.substring(expressionContextStart + 1, i);
            parts.add(new ExpressionTemplatePart(templateString.substring(expressionContextStart, i + 1)));
            expressionContextStart = -1;
            expressionNestLevel = 0;
            processedUntil = i + 1;
        }
        if (processedUntil != templateString.length()) {
            parts.add(new LiteralTemplatePart(templateString.substring(processedUntil)));
        }
        return parts;
    }
}

